/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.legacy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SmokeParticle
extends SimpleAnimatedParticle {
    public static final ParticleRenderType TRANSPARENT_SMOKE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }

        public String toString() {
            return "TRANSPARENT_SMOKE";
        }
    };
    private LerpedFloat ascendScale = LerpedFloat.linear().startWithValue(1.0);
    private double baseYd;
    private final boolean stationarySource;

    protected SmokeParticle(ClientLevel world, SmokeParticleData data, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.f_46441_.m_188501_() * 0.5f);
        double scale = 0.1;
        this.f_107215_ = dx * scale;
        this.baseYd = this.f_107216_ = dy * scale + (double)(this.f_107223_.m_188501_() / 500.0f);
        this.f_107217_ = dz * scale;
        this.f_107226_ = 3.0E-6f;
        this.f_107663_ = 1.5f;
        this.m_107257_(data.stationary ? 400 : (Integer)CRConfigs.client().smokeLifetime.get());
        this.m_107264_(x, y, z);
        this.f_107231_ = this.f_107204_ = world.f_46441_.m_188501_() * (float)Math.PI;
        this.m_108337_(sprite.m_5819_(((SmokeQuality)((Object)CRConfigs.client().smokeQuality.get())).ordinal(), SmokeQuality.values().length - 1));
        this.f_107230_ = data.stationary ? 0.25f : 0.1f;
        this.ascendScale.chase(data.stationary ? 0.3 : 0.1, data.stationary ? 0.001 : 0.03, LerpedFloat.Chaser.EXP);
        this.f_107227_ = data.red;
        this.f_107228_ = data.green;
        this.f_107229_ = data.blue;
        this.stationarySource = data.stationary;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return TRANSPARENT_SMOKE;
    }

    public void m_5989_() {
        float diffusionScale;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_ || this.f_107230_ <= 0.0f) {
            this.m_107274_();
            return;
        }
        float f = diffusionScale = this.stationarySource ? 800.0f : 500.0f;
        if (this.f_107224_ > 350) {
            diffusionScale = 5000.0f;
        } else if (this.f_107224_ > 300) {
            diffusionScale = Mth.m_14179_((float)((float)(this.f_107224_ - 300) / 50.0f), (float)(this.stationarySource ? 800.0f : 500.0f), (float)5000.0f);
        }
        this.f_107215_ += (double)(this.f_107223_.m_188501_() / diffusionScale * (float)(this.f_107223_.m_188499_() ? 1 : -1));
        this.f_107217_ += (double)(this.f_107223_.m_188501_() / diffusionScale * (float)(this.f_107223_.m_188499_() ? 1 : -1));
        this.f_107216_ = this.baseYd * (double)this.ascendScale.getValue();
        this.ascendScale.tickChaser();
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107224_ >= this.f_107225_ - 100 && this.f_107230_ > 0.01f) {
            this.f_107230_ -= 0.015f;
        }
    }

    public void m_5744_(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        this.render(buffer, renderInfo, partialTicks, 0.0f, 1.0f, 1.0f);
        if (((Boolean)CRConfigs.client().thickerSmoke.get()).booleanValue()) {
            this.render(buffer, renderInfo, partialTicks, 0.3f, 0.5f, 0.75f);
            this.render(buffer, renderInfo, partialTicks, -0.3f, 0.5f, 0.75f);
        }
    }

    private void render(VertexConsumer buffer, Camera renderInfo, float partialTicks, float offsetDepth, float size, float alphaFactor) {
        Quaternionf quaternion;
        Vec3 vec3 = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float g = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float h = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float i = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-size, -size, offsetDepth), new Vector3f(-size, size, offsetDepth), new Vector3f(size, size, offsetDepth), new Vector3f(size, -size, offsetDepth)};
        float j = this.m_5902_(partialTicks);
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f2 = vector3fs[k];
            vector3f2.rotate((Quaternionfc)quaternion);
            vector3f2.mul(j);
            vector3f2.add(f, g, h);
        }
        float l = this.m_5970_();
        float m = this.m_5952_();
        float n = this.m_5951_();
        float o = this.m_5950_();
        int p = this.m_6355_(partialTicks);
        buffer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(m, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFactor).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(m, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFactor).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(l, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFactor).m_85969_(p).m_5752_();
        buffer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(l, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFactor).m_85969_(p).m_5752_();
    }

    public int m_6355_(float partialTick) {
        BlockPos blockpos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        return this.f_107208_.m_46749_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    public static enum SmokeQuality {
        LOW("smoke_16"),
        MEDIUM("smoke_32"),
        HIGH("smoke_64"),
        ULTRA("smoke");

        public final String name;

        private SmokeQuality(String name) {
            this.name = name;
        }
    }

    public static class Factory
    implements ParticleProvider<SmokeParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(SmokeParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SmokeParticle(worldIn, data, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

