/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;

public class ConductorSecondaryHeadLayer<T extends ConductorEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final ItemInHandRenderer itemInHandRenderer;

    public ConductorSecondaryHeadLayer(RenderLayerParent<T, M> renderer, EntityModelSet skullModels, ItemInHandRenderer itemInHandRenderer) {
        this(renderer, skullModels, 1.0f, 1.0f, 1.0f, itemInHandRenderer);
    }

    public ConductorSecondaryHeadLayer(RenderLayerParent<T, M> renderer, EntityModelSet skullModels, float scaleX, float scaleY, float scaleZ, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)skullModels);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T conductor, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemStack = ((ConductorEntity)((Object)conductor)).getSecondaryHeadStack();
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
        if (conductor.m_6162_()) {
            matrixStack.m_85837_(0.0, 0.03125, 0.0);
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
            matrixStack.m_85837_(0.0, 1.0, 0.0);
        }
        ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(matrixStack);
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
            CompoundTag compoundTag;
            matrixStack.m_85841_(1.1875f, -1.1875f, -1.1875f);
            GameProfile gameProfile = null;
            if (itemStack.m_41782_() && (compoundTag = itemStack.m_41783_()).m_128425_("SkullOwner", 10)) {
                gameProfile = NbtUtils.m_129228_((CompoundTag)compoundTag.m_128469_("SkullOwner"));
            }
            matrixStack.m_85837_(-0.5, 0.0, -0.5);
            SkullBlock.Type type = ((AbstractSkullBlock)((BlockItem)item).m_40614_()).m_48754_();
            SkullModelBase skullModelBase = this.skullModels.get(type);
            RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)gameProfile);
            SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)limbSwing, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight, (SkullModelBase)skullModelBase, (RenderType)renderType);
        } else if (!(item instanceof ArmorItem) || ((ArmorItem)item).m_40402_() != EquipmentSlot.HEAD) {
            CustomHeadLayer.m_174483_((PoseStack)matrixStack, (boolean)false);
            this.itemInHandRenderer.m_269530_(conductor, itemStack, ItemDisplayContext.HEAD, false, matrixStack, buffer, packedLight);
        }
        matrixStack.m_85849_();
    }
}

