/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.mixin.BeehiveBlockEntity$BeeDataAccess;
import mcp.mobius.waila.mixin.BeehiveBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import org.jetbrains.annotations.Nullable;

public enum BeehiveDataProvider implements IDataProvider<BeehiveBlockEntity>
{
    INSTANCE;

    public static final ResourceLocation OCCUPANTS;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BeehiveBlockEntity> accessor, IPluginConfig config) {
        List<BeehiveBlockEntity$BeeDataAccess> stored;
        if (config.getBoolean(Options.BEE_HIVE_OCCUPANTS) && !(stored = ((BeehiveBlockEntityAccess)accessor.getTarget()).wthit_stored()).isEmpty()) {
            ArrayList<OccupantsData.Occupant> occupants = new ArrayList<OccupantsData.Occupant>(stored.size());
            for (BeehiveBlockEntity$BeeDataAccess beeData : stored) {
                CompoundTag beeNbt = beeData.wthit_entityData();
                Optional entityType = EntityType.m_20637_((CompoundTag)beeNbt);
                if (entityType.isEmpty()) continue;
                String customName = beeNbt.m_128425_("CustomName", 8) ? beeNbt.m_128461_("CustomName") : null;
                occupants.add(new OccupantsData.Occupant((EntityType)entityType.get(), customName));
            }
            if (!occupants.isEmpty()) {
                data.addImmediate(new OccupantsData(occupants));
            }
        }
    }

    static {
        OCCUPANTS = new ResourceLocation("bee.occupants");
    }

    public record OccupantsData(List<Occupant> occupants) implements IData
    {
        public OccupantsData(FriendlyByteBuf buf) {
            this(buf.m_236845_(b -> new Occupant((EntityType)b.m_236816_((IdMap)BuiltInRegistries.f_256780_), (String)b.m_236868_(FriendlyByteBuf::m_130277_))));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_236828_(this.occupants, (b, occupant) -> {
                b.m_236818_((IdMap)BuiltInRegistries.f_256780_, occupant.entityType);
                b.m_236821_((Object)occupant.customName, FriendlyByteBuf::m_130070_);
            });
        }

        public record Occupant(EntityType<?> entityType, @Nullable String customName) {
        }
    }
}

