/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IToolType;
import mcp.mobius.waila.plugin.harvest.tool.ToolTier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ToolType
implements IToolType,
IToolType.Builder0,
IToolType.Builder1,
IToolType.Builder2,
IToolType.Builder3 {
    private static final Map<ResourceLocation, ToolType> MAP = new LinkedHashMap<ResourceLocation, ToolType>();
    public ResourceLocation id;
    public ItemStack lowestTierStack;
    public Predicate<BlockState> blockPredicate;
    public Predicate<ItemStack> itemPredicate;
    public Component text;
    private final Supplier<Map<ToolTier, ItemStack>> icons = Suppliers.memoize(() -> {
        Collection<ToolTier> tiers = ToolTier.all();
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        for (Item item : BuiltInRegistries.f_257033_) {
            ItemStack stack = item.m_7968_();
            if (!this.itemPredicate.test(stack)) continue;
            for (ToolTier registeredTier : tiers) {
                TieredItem tiered;
                ToolTier itemTier;
                if (map.containsKey((Object)registeredTier) || !(item instanceof TieredItem) || (itemTier = ToolTier.get((tiered = (TieredItem)item).m_43314_())) == null || !itemTier.isEqualTo(registeredTier)) continue;
                map.put((Object)registeredTier, (Object)stack);
            }
        }
        if (map.size() < tiers.size()) {
            for (ToolTier tier : tiers) {
                map.putIfAbsent((Object)tier, (Object)this.lowestTierStack);
            }
        }
        return map;
    });

    public ItemStack getIcon(ToolTier tier) {
        if (tier == ToolTier.NONE) {
            return this.lowestTierStack;
        }
        return this.icons.get().get(tier);
    }

    public void bind(ResourceLocation id) {
        this.id = id;
        this.text = Component.m_237115_((String)("tooltip.waila.harvest.tool." + id.m_214298_()));
        MAP.put(id, this);
    }

    public static Collection<ToolType> all() {
        return MAP.values();
    }

    @Override
    public IToolType.Builder1 lowestTierStack(ItemStack stack) {
        this.lowestTierStack = stack;
        return this;
    }

    @Override
    public IToolType.Builder1 lowestTierItem(ItemLike item) {
        this.lowestTierStack = new ItemStack(item);
        return this;
    }

    @Override
    public IToolType.Builder2 blockPredicate(Predicate<BlockState> predicate) {
        this.blockPredicate = predicate;
        return this;
    }

    @Override
    public IToolType.Builder2 blockTag(TagKey<Block> tag) {
        this.blockPredicate = state -> state.m_204336_(tag);
        return this;
    }

    @Override
    public IToolType.Builder2 blockTag(ResourceLocation tag) {
        return this.blockTag((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag));
    }

    @Override
    public IToolType.Builder3 itemPredicate(Predicate<ItemStack> predicate) {
        this.itemPredicate = predicate;
        return this;
    }

    @Override
    public IToolType.Builder3 itemTag(TagKey<Item> tag) {
        this.itemPredicate = stack -> stack.m_204117_(tag);
        return this;
    }

    @Override
    public IToolType.Builder3 itemTag(ResourceLocation tag) {
        return this.itemTag((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
    }

    @Override
    public IToolType build() {
        return this;
    }
}

