/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.util.bee;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import ttv.migami.jeg.blockentity.BeehiveBlockEntityAbstract;
import ttv.migami.jeg.util.bee.IInhabitantStorage;

public class InhabitantStorage
implements IInhabitantStorage,
INBTSerializable<CompoundTag> {
    private List<BeehiveBlockEntityAbstract.Inhabitant> inhabitantList = Lists.newArrayList();

    @Override
    @Nonnull
    public List<BeehiveBlockEntityAbstract.Inhabitant> getInhabitants() {
        return this.inhabitantList;
    }

    @Override
    public int countInhabitants() {
        return this.inhabitantList.size();
    }

    @Override
    public void setInhabitants(List<BeehiveBlockEntityAbstract.Inhabitant> inhabitantList) {
        this.inhabitantList = inhabitantList;
    }

    @Override
    public void addInhabitant(BeehiveBlockEntityAbstract.Inhabitant inhabitant) {
        this.inhabitantList.add(inhabitant);
    }

    @Override
    public void clearInhabitants() {
        this.inhabitantList.clear();
    }

    @Override
    @Nonnull
    public ListTag getInhabitantListAsListNBT() {
        ListTag listNBT = new ListTag();
        for (BeehiveBlockEntityAbstract.Inhabitant inhabitant : this.getInhabitants()) {
            CompoundTag copyNbt = inhabitant.nbt.m_6426_();
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("EntityData", (Tag)copyNbt);
            tag.m_128405_("TicksInHive", inhabitant.ticksInHive);
            if (inhabitant.flowerPos != null) {
                tag.m_128365_("FlowerPos", (Tag)NbtUtils.m_129224_((BlockPos)inhabitant.flowerPos));
            }
            tag.m_128405_("MinOccupationTicks", inhabitant.minOccupationTicks);
            tag.m_128359_("Name", inhabitant.localizedName);
            listNBT.add((Object)tag);
        }
        return listNBT;
    }

    @Override
    public void setInhabitantsFromListNBT(ListTag list) {
        this.clearInhabitants();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            BlockPos flowerPos = tag.m_128441_("FlowerPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FlowerPos")) : null;
            BeehiveBlockEntityAbstract.Inhabitant inhabitant = new BeehiveBlockEntityAbstract.Inhabitant(tag.m_128469_("EntityData"), tag.m_128451_("TicksInHive"), tag.m_128451_("MinOccupationTicks"), flowerPos, tag.m_128461_("Name"));
            this.addInhabitant(inhabitant);
        }
    }

    public CompoundTag serializeNBT() {
        ListTag listNBT = this.getInhabitantListAsListNBT();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Inhabitants", (Tag)listNBT);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("Inhabitants", 10);
        this.setInhabitantsFromListNBT(list);
    }

    @Override
    public void onContentsChanged() {
    }
}

