/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.ai.Faction;
import ttv.migami.jeg.entity.ai.GunMobValues;
import ttv.migami.jeg.entity.ai.GunnerManager;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.GunItem;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"justEnoughGuns").then(Commands.m_82127_((String)"spawnPatrol").then(Commands.m_82129_((String)"faction", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            List<String> factionConfigs = GunnerManager.getConfigFactions();
            for (String factionConfig : factionConfigs) {
                String factionName = factionConfig.split("\\|")[0];
                builder.suggest(factionName);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"forceGuns", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"spawnRadius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            boolean forceGuns = BoolArgumentType.getBool((CommandContext)context, (String)"forceGuns");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int spread = IntegerArgumentType.getInteger((CommandContext)context, (String)"spawnRadius");
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, forceGuns, spread);
        }))).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            boolean forceGuns = BoolArgumentType.getBool((CommandContext)context, (String)"forceGuns");
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, forceGuns, 10);
        }))).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, false, 10);
        })))))).then(Commands.m_82127_((String)"spawnRaid").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            source.m_288197_(() -> Component.m_130674_((String)"Raids are not ready yet! And neither are you!"), true);
            source.m_288197_(() -> Component.m_130674_((String)"Stay tuned for future updates! @MigaMiDev on Youtube!"), true);
            source.m_288197_(() -> Component.m_130674_((String)""), true);
            source.m_288197_(() -> Component.m_130674_((String)"Your boy, -MigaMi"), true);
            ServerLevel level = source.m_81372_();
            int x = level.f_46441_.m_216339_(-50, 50);
            int z = level.f_46441_.m_216339_(-50, 50);
            level.m_5594_(null, BlockPos.m_274446_((Position)source.m_81371_().m_82520_((double)x, 32.0, (double)z)), (SoundEvent)ModSounds.DARK_HORN.get(), SoundSource.HOSTILE, 1000.0f, 1.0f);
            for (ServerPlayer player : level.m_6907_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 260, 0, true, false));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"spawnTrumpetBoi").then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            return ModCommands.executeSpawnTrumpetBoi(source, pos);
        }))));
    }

    private static int executeSpawnPatrol(CommandSourceStack source, String factionName, int size, Vec3 pos, boolean forceGuns, int spread) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        GunnerManager gunnerManager = new GunnerManager(GunnerManager.getConfigFactions());
        Faction faction = gunnerManager.getFactionByName(factionName);
        if (faction == null) {
            source.m_81352_(Component.m_130674_((String)("Faction '" + factionName + "' does not exist!")));
            return 0;
        }
        for (int i = 0; i < size; ++i) {
            Mob mob = ModCommands.spawnFactionMob(level, faction, pos, forceGuns, spread);
            if (mob != null) continue;
            source.m_81352_(Component.m_130674_((String)("Could not spawn mob for faction " + factionName)));
            return 0;
        }
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + factionName));
        source.m_288197_(() -> Component.m_130674_((String)("Spawned " + size + " mobs for faction " + factionLang.getString())), true);
        if (!forceGuns) {
            source.m_81352_(Component.m_130674_((String)"Please note that by not setting 'forceGuns' to true, the chance of them spawning with Guns is entirely determined by your Config Files!"));
        }
        return 1;
    }

    private static Mob spawnFactionMob(ServerLevel level, Faction faction, Vec3 startPos, boolean forceGuns, int spread) {
        Random random = new Random();
        String mobName = faction.getMobs().get(random.nextInt(faction.getMobs().size()));
        JustEnoughGuns.LOGGER.atInfo().log(mobName);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobName));
        if (entityType == null) {
            return null;
        }
        Mob mob = (Mob)entityType.m_20615_((Level)level);
        if (mob != null) {
            double offsetX = (random.nextDouble() - 0.5) * (double)spread;
            double offsetZ = (random.nextDouble() - 0.5) * (double)spread;
            mob.m_6034_(startPos.f_82479_ + offsetX, startPos.f_82480_, startPos.f_82481_ + offsetZ);
            long totalDayTime = mob.m_9236_().m_46468_();
            int currentDay = (int)(totalDayTime / 24000L);
            int currentChance = Math.min(GunMobValues.initialChance + currentDay * GunMobValues.chanceIncrement, GunMobValues.maxChance);
            if (mob.m_217043_().m_188503_(100) < currentChance || forceGuns) {
                mob.m_20049_("MobGunner");
            }
            mob.m_213945_(RandomSource.m_216327_(), mob.m_9236_().m_6436_(mob.m_20097_()));
            if (mob.m_19880_().contains("MobGunner")) {
                Item item;
                boolean elite;
                Item gun = faction.getRandomGun(random.nextBoolean());
                boolean bl = elite = (double)mob.m_217043_().m_188501_() > GunMobValues.eliteChance && GunMobValues.elitesEnabled;
                if (elite) {
                    mob.m_20049_("EliteGunner");
                    gun = faction.getEliteGun();
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42354_));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, true));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 1, false, false));
                }
                ItemStack modifiedGun = new ItemStack((ItemLike)gun);
                mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
                if (modifiedGun.m_41783_() != null && (item = modifiedGun.m_41720_()) instanceof GunItem) {
                    GunItem gunItem = (GunItem)item;
                    Gun gunModified = gunItem.getModifiedGun(modifiedGun);
                    modifiedGun.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
                }
            } else if (mob instanceof Piglin) {
                Piglin piglin;
                piglin.m_8061_(EquipmentSlot.MAINHAND, (double)(piglin = (Piglin)mob).m_217043_().m_188501_() < 0.5 ? new ItemStack((ItemLike)Items.f_42717_) : new ItemStack((ItemLike)Items.f_42430_));
            }
            level.m_7967_((Entity)mob);
        }
        return mob;
    }

    private static int executeSpawnTrumpetBoi(CommandSourceStack source, Vec3 pos) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command.\nNo Trumpet Boi :c"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        Skeleton trumpetBoi = new Skeleton(EntityType.f_20524_, (Level)level);
        trumpetBoi.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        trumpetBoi.m_20049_("TrumpetBoi");
        level.m_7967_((Entity)trumpetBoi);
        source.m_288197_(() -> Component.m_130674_((String)"Spawned a Trumpet Boi!"), true);
        return 1;
    }
}

