/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEffects;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventBus {
    static final Map<UUID, Long> runningPlayers = new HashMap<UUID, Long>();
    private static final long RUN_DURATION_THRESHOLD = 2000L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Item item;
            Player player = event.player;
            UUID playerId = player.m_20148_();
            if (player.m_20142_() && (item = player.m_21205_().m_41720_()) instanceof GunItem) {
                Item item2;
                GunItem gunItem = (GunItem)item;
                long currentTime = System.currentTimeMillis();
                runningPlayers.putIfAbsent(playerId, currentTime);
                ItemCooldowns tracker = player.m_36335_();
                if (runningPlayers.get(playerId) != null && currentTime - runningPlayers.get(playerId) >= 2000L && !tracker.m_41519_((Item)gunItem) && !player.m_21023_(MobEffects.f_19597_) && (item2 = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_()) instanceof SwordItem) {
                    SwordItem swordItem = (SwordItem)item2;
                    ItemStack bayonet = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_());
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 0, false, false));
                    float damage = swordItem.m_43299_();
                    int maxDamage = bayonet.m_41776_();
                    int currentDamage = bayonet.m_41773_();
                    if ((double)currentDamage >= (double)maxDamage / 1.5) {
                        damage = 0.0f;
                    }
                    damage += (float)bayonet.getEnchantmentLevel(Enchantments.f_44977_);
                    AABB boundingBox = player.m_20191_().m_82400_(1.5);
                    if (runningPlayers.containsKey(playerId)) {
                        float finalDamage = damage;
                        player.m_9236_().m_45933_((Entity)player, boundingBox).forEach(entity -> ServerPlayHandler.handleCharge(player, entity, finalDamage, currentDamage, maxDamage, bayonet));
                        Vec3 start = player.m_20299_(1.0f);
                        Vec3 look = player.m_20154_();
                        Vec3 end = start.m_82549_(look.m_82490_(0.5));
                        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                            Vec3 pushBackDirection = player.m_20154_().m_82541_().m_82490_(-1.0);
                            BlockPos blockPos = ServerPlayHandler.rayTrace(player, 4.0);
                            BlockState blockState = player.m_9236_().m_8055_(blockPos);
                            double pushBackForce = 1.0 + (double)GunModifierHelper.getSwordKnockBack(player) / 4.0;
                            player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                            player.m_5997_(pushBackDirection.f_82479_ * pushBackForce, 0.5, pushBackDirection.f_82481_ * pushBackForce);
                        }
                    }
                }
            } else {
                runningPlayers.remove(playerId);
            }
        }
    }

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41783_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            int damageAmount;
            Item item2;
            ItemCooldowns tracker;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (!gun.getGeneral().canFireUnderwater() && player.m_5842_() && !((Boolean)Config.COMMON.gameplay.underwaterFiring.get()).booleanValue()) {
                event.setCanceled(true);
            }
            if ((tracker = player.m_36335_()).m_41519_(heldItem.m_41720_()) && gun.getGeneral().getFireMode() == FireMode.PULSE) {
                event.setCanceled(true);
            }
            if ((item2 = heldItem.m_41720_()) instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGunItem = (AnimatedGunItem)item2;
                long id = GeoItem.getId((ItemStack)heldItem);
                AnimationController animationController = (AnimationController)animatedGunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                if (heldItem.m_41783_() != null && animationController.getCurrentAnimation() != null && animationController.getCurrentAnimation().animation().name().matches("draw")) {
                    event.setCanceled(true);
                }
            }
            boolean explosiveAmmo = false;
            double chance = 0.975;
            if (Gun.hasAttachmentEquipped(heldItem, IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                explosiveAmmo = true;
                chance = 0.975;
            }
            int n = damageAmount = explosiveAmmo ? 5 : 1;
            if (heldItem.m_41763_() && tag != null) {
                if (heldItem.m_41773_() >= heldItem.m_41776_() - damageAmount) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), gun.getGeneral().getRate());
                    event.setCanceled(true);
                }
                int maxDamage = heldItem.m_41776_();
                int currentDamage = heldItem.m_41773_();
                double explosiveJam = 1.75;
                if (explosiveAmmo) {
                    explosiveJam = Double.MAX_VALUE;
                }
                if ((double)currentDamage >= (double)maxDamage / explosiveJam && ((Boolean)Config.COMMON.gameplay.gunJamming.get()).booleanValue()) {
                    if (Math.random() >= chance) {
                        event.getEntity().m_5496_((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), 1.0f, 1.0f);
                        int coolDown = gun.getGeneral().getRate() * 10;
                        if (coolDown > 60) {
                            coolDown = 60;
                        }
                        MutableComponent message = Component.m_237115_((String)"chat.jeg.jam").m_130940_(ChatFormatting.GRAY);
                        player.m_5661_((Component)message, true);
                        event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), coolDown);
                        event.setCanceled(true);
                    }
                } else if (tag.m_128451_("AmmoCount") >= 1) {
                    GunEventBus.broken(heldItem, level, player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41783_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (gunItem != ModItems.SUBSONIC_RIFLE.get() && gunItem != ModItems.SUPERSONIC_SHOTGUN.get() && gunItem != ModItems.HYPERSONIC_CANNON.get() && !GunModifierHelper.isSilencedFire(heldItem)) {
                level.m_220400_((Entity)player, GameEvent.f_157812_, player.m_20318_(1.0f));
            }
            if (gun.getProjectile().ejectsCasing() && tag != null && (tag.m_128451_("AmmoCount") >= 1 || player.m_150110_().f_35937_)) {
                if (!(gunItem instanceof AnimatedGunItem)) {
                    GunEventBus.ejectCasing(level, (LivingEntity)player);
                }
                if (gunItem == ModItems.ROCKET_LAUNCHER.get()) {
                    GunEventBus.firingSmoke(level, player);
                }
            }
            boolean explosiveAmmo = false;
            if (Gun.hasAttachmentEquipped(heldItem, IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                explosiveAmmo = true;
            }
            if (heldItem.m_41763_() && tag != null) {
                if (tag.m_128451_("AmmoCount") >= 1 && ((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() && player instanceof Player) {
                    GunEventBus.damageGun(heldItem, level, player, explosiveAmmo);
                    GunEventBus.damageAttachments(heldItem, level, player);
                }
                if ((double)heldItem.m_41773_() >= (double)heldItem.m_41776_() / 1.5) {
                    float randomPitch = 1.5f + player.m_217043_().m_188501_() * 0.25f;
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.3f, randomPitch);
                }
            }
            float damage = gun.getProjectile().getDamage();
            damage = GunModifierHelper.getModifiedDamage(heldItem, gun, damage);
            damage = GunEnchantmentHelper.getAcceleratorDamage(heldItem, damage);
            damage = GunEnchantmentHelper.getWitheredDamage(heldItem, damage);
            if (gunItem == ModItems.TYPHOONEE.get()) {
                GunEventBus.typhooneeBlast(level, (LivingEntity)player, damage);
            }
            if (gunItem == ModItems.SUPERSONIC_SHOTGUN.get()) {
                GunEventBus.soundwaveBlast(level, (LivingEntity)player, damage, gun);
            }
            if (gunItem == ModItems.HYPERSONIC_CANNON.get()) {
                GunEventBus.hypersonicBlast(level, (LivingEntity)player, damage);
            }
            if (Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.TRUMPET.get() && gunItem.getGun().getGeneral().getProjectileAmount() > 3) {
                GunEventBus.trumpetBlast(level, player);
            }
            if (gunItem == ModItems.ROCKET_LAUNCHER.get()) {
                GunEventBus.recoil(player, -1.0);
            }
            if (heldItem.m_41720_() == ModItems.INFANTRY_RIFLE.get() && tag != null && !Gun.hasAttachmentEquipped(heldItem, IAttachment.Type.MAGAZINE) && tag.m_128451_("AmmoCount") == 1) {
                event.getEntity().m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)ModSounds.INFANTRY_RIFLE_PING.get(), SoundSource.MASTER, 3.0f, 1.0f);
            }
        }
    }

    public static void broken(ItemStack stack, Level level, Player player) {
        int maxDamage = stack.m_41776_();
        int currentDamage = stack.m_41773_();
        if (currentDamage >= maxDamage - 2) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void damageGun(ItemStack stack, Level level, Player player, boolean explosiveAmmo) {
        if (!player.m_150110_().f_35937_ && stack.m_41763_()) {
            int damageAmount;
            int maxDamage = stack.m_41776_();
            int currentDamage = stack.m_41773_();
            int n = damageAmount = explosiveAmmo ? 5 : 1;
            if (currentDamage >= maxDamage - damageAmount) {
                if (currentDamage >= maxDamage - 2) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                stack.m_41622_(damageAmount, (LivingEntity)player, null);
            }
        }
    }

    public static void damageAttachments(ItemStack stack, Level level, Player player) {
        if (!player.m_150110_().f_35937_ && stack.m_41720_() instanceof GunItem) {
            ItemStack underBarrelStack;
            ItemStack stockStack;
            ItemStack barrelStack;
            ItemStack scopeStack = Gun.getAttachment(IAttachment.Type.SCOPE, stack);
            if (scopeStack.getEnchantmentLevel(Enchantments.f_44962_) == 0 && Gun.hasAttachmentEquipped(stack, IAttachment.Type.SCOPE) && scopeStack.m_41763_()) {
                int maxDamage = scopeStack.m_41776_();
                int currentDamage = scopeStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Scope");
                    MutableComponent message = Component.m_237115_((String)"chat.jeg.attachment_broke").m_130940_(ChatFormatting.GRAY);
                    player.m_5661_((Component)message, true);
                } else {
                    scopeStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            if (((barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, stack)).getEnchantmentLevel(Enchantments.f_44962_) == 0 || barrelStack.m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) && Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL) && barrelStack.m_41763_() && !(barrelStack.m_41720_() instanceof SwordItem)) {
                int maxDamage = barrelStack.m_41776_();
                int currentDamage = barrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Barrel");
                    MutableComponent message = Component.m_237115_((String)"chat.jeg.attachment_broke").m_130940_(ChatFormatting.GRAY);
                    player.m_5661_((Component)message, true);
                } else {
                    barrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            if ((stockStack = Gun.getAttachment(IAttachment.Type.STOCK, stack)).getEnchantmentLevel(Enchantments.f_44962_) == 0 && Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK) && stockStack.m_41763_()) {
                int maxDamage = stockStack.m_41776_();
                int currentDamage = stockStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Stock");
                    MutableComponent message = Component.m_237115_((String)"chat.jeg.attachment_broke").m_130940_(ChatFormatting.GRAY);
                    player.m_5661_((Component)message, true);
                } else {
                    stockStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            if ((underBarrelStack = Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack)).getEnchantmentLevel(Enchantments.f_44962_) == 0 && Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL) && underBarrelStack.m_41763_()) {
                int maxDamage = underBarrelStack.m_41776_();
                int currentDamage = underBarrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Under_Barrel");
                    MutableComponent message = Component.m_237115_((String)"chat.jeg.attachment_broke").m_130940_(ChatFormatting.GRAY);
                    player.m_5661_((Component)message, true);
                } else {
                    underBarrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
        }
    }

    public static void typhooneeBlast(Level level, LivingEntity shooter, float damage) {
        HitResult result = shooter.m_19907_(64.0, 0.0f, false);
        Vec3 userPos = shooter.m_146892_();
        Vec3 targetPos = result.m_82450_();
        Vec3 distanceTo = targetPos.m_82546_(userPos);
        Vec3 normal = distanceTo.m_82541_();
        if (!level.m_5776_()) {
            Entity z2;
            EntityHitResult e;
            for (int i = 3; i < Mth.m_14107_((double)distanceTo.m_82553_()); ++i) {
                Vec3 vec33 = userPos.m_82549_(normal.m_82490_((double)i));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.TYPHOONEE_BEAM.get(), true, vec33.m_7096_(), vec33.m_7098_(), vec33.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    if (!shooter.m_5842_()) {
                        ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123796_, true, vec33.m_7096_(), vec33.m_7098_(), vec33.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    } else {
                        ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123795_, true, vec33.m_7096_(), vec33.m_7098_(), vec33.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (shooter.m_5842_()) continue;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 3, 0.3, 0.3, 0.3, 1.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.3, 0.3, 0.3, 0.0);
            }
            int radius = 2;
            BlockPos blockPos = BlockPos.m_274446_((Position)result.m_82450_());
            if (((Boolean)Config.COMMON.gameplay.griefing.extinguishFire.get()).booleanValue()) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z2 = -radius; z2 <= radius; ++z2) {
                            BlockPos blockPos2 = blockPos.m_7918_(x, y, z2);
                            BlockState blockState = level.m_8055_(blockPos2);
                            if (!(blockState.m_60734_() instanceof FireBlock)) continue;
                            level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
                            level.m_5594_(null, BlockPos.m_274446_((Position)result.m_82450_()), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.2f, 1.0f);
                        }
                    }
                }
            }
            if ((e = ProjectileUtil.m_37304_((Level)level, (Entity)shooter, (Vec3)userPos, (Vec3)targetPos, (AABB)new AABB(userPos, targetPos), ServerPlayHandler::canDamage)) != null && (z2 = e.m_82443_()) instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)z2;
                float advantageMultiplier = 1.0f;
                if (entity.m_6095_().m_204039_(ModTags.Entities.FIRE)) {
                    advantageMultiplier = 2.0f;
                }
                if (entity.m_6060_()) {
                    entity.m_252836_();
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                entity.m_6469_(shooter.m_269291_().m_269285_((Entity)shooter), damage * advantageMultiplier);
                double d1 = 0.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
                double d0 = 2.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
                entity.m_5997_(normal.m_7096_() * d0, normal.m_7098_() * d1, normal.m_7094_() * d0);
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DEAFENED.get(), 100, 0, false, false));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            }
        }
    }

    public static void soundwaveBlast(Level level, LivingEntity shooter, float maxDamage, Gun gun) {
        double angle;
        double distance;
        Vec3 lookVec = shooter.m_20154_();
        double offsetX = lookVec.f_82479_ * 1.8;
        double offsetY = lookVec.f_82480_ * 1.8;
        double offsetZ = lookVec.f_82481_ * 1.8;
        Vec3 playerPos = shooter.m_20318_(1.0f).m_82520_(offsetX, offsetY + (double)shooter.m_20192_(), offsetZ);
        double attackRange = 8.0;
        double sweepAngle = Math.toRadians(gun.getGeneral().getSpread());
        double maxDistance = 10.0;
        Vec3 playerPos2 = shooter.m_20182_();
        BlockPos playerBlockPos = shooter.m_20183_();
        int fireExtinguishRange = 10;
        for (Object pos : BlockPos.m_121940_((BlockPos)playerBlockPos.m_7918_(-fireExtinguishRange, -fireExtinguishRange, -fireExtinguishRange), (BlockPos)playerBlockPos.m_7918_(fireExtinguishRange, fireExtinguishRange, fireExtinguishRange))) {
            BlockState blockState = level.m_8055_((BlockPos)pos);
            if (!blockState.m_60713_(Blocks.f_50083_)) continue;
            Vec3 firePos = Vec3.m_82512_((Vec3i)pos).m_82546_(playerPos2);
            distance = firePos.m_82553_();
            angle = Math.acos(firePos.m_82541_().m_82526_(lookVec.m_82541_()));
            if (!(angle < sweepAngle / 2.0) || !(distance <= maxDistance)) continue;
            level.m_46597_((BlockPos)pos, Blocks.f_50016_.m_49966_());
        }
        List entities = level.m_45976_(LivingEntity.class, shooter.m_20191_().m_82400_(attackRange));
        level.m_5594_(null, shooter.m_20097_(), SoundEvents.f_215734_, SoundSource.PLAYERS, 2.0f, 1.0f);
        for (LivingEntity entity : entities) {
            double distanceMultiplier;
            float adjustedDamage;
            if (entity == shooter) continue;
            Vec3 entityPos = entity.m_20182_().m_82546_(playerPos2);
            distance = entityPos.m_82553_();
            angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
            if (!(angle < sweepAngle / 2.0) || !((adjustedDamage = (float)((double)maxDamage * (distanceMultiplier = 1.0 - Math.min(distance / maxDistance, 1.0)))) > 0.0f)) continue;
            entity.m_6469_(shooter.m_269291_().m_269285_((Entity)shooter), adjustedDamage);
            entity.f_19802_ = 0;
            if (shooter.m_9236_().f_46443_) continue;
            ServerLevel serverLevel = (ServerLevel)shooter.m_9236_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235900_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 12, 0.2, 0.0, 0.3, 0.1);
        }
        level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 2.0, offsetY / 2.0, offsetZ / 2.0);
        level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 4.0, offsetY / 4.0, offsetZ / 4.0);
        level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 1.5, offsetY / 1.5, offsetZ / 1.5);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.SONIC_RING.get(), true, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, 5, 0.0, 0.0, 0.0, 0.2);
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_SONIC_RING.get(), true, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.1);
        }
    }

    public static void hypersonicBlast(Level level, LivingEntity shooter, float damage) {
        Vec3 userPos = shooter.m_146892_();
        Vec3 targetPos = userPos.m_82549_(shooter.m_20154_().m_82490_(100.0));
        Vec3 distanceTo = targetPos.m_82546_(userPos);
        Vec3 normal = distanceTo.m_82541_();
        if (!level.m_5776_()) {
            Entity entity2;
            EntityHitResult e = ProjectileUtil.m_37304_((Level)level, (Entity)shooter, (Vec3)userPos, (Vec3)targetPos, (AABB)new AABB(userPos, targetPos), entity -> entity instanceof LivingEntity && entity != shooter);
            if (e != null && (entity2 = e.m_82443_()) instanceof LivingEntity) {
                LivingEntity entity3 = (LivingEntity)entity2;
                float advantageMultiplier = 1.0f;
                if (entity3.m_6060_()) {
                    entity3.m_252836_();
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity3.m_20185_(), entity3.m_20186_() + 1.0, entity3.m_20189_(), 6, 0.3, 0.3, 0.3, 0.0);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235900_, entity3.m_20185_(), entity3.m_20186_() + (double)entity3.m_20206_() * 0.5, entity3.m_20189_(), 12, 0.2, 0.0, 0.3, 0.1);
                entity3.m_6469_(shooter.m_269291_().m_269285_((Entity)shooter), damage * advantageMultiplier);
                entity3.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DEAFENED.get(), 100, 0, false, false));
                entity3.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50));
                entity3.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 120));
            }
            for (int i = 3; i < Mth.m_14107_((double)distanceTo.m_82553_()); ++i) {
                Vec3 vec33 = userPos.m_82549_(normal.m_82490_((double)i));
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_235902_, true, vec33.m_7096_(), vec33.m_7098_(), vec33.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void trumpetBlast(Level level, Player player) {
        Vec3 lookVec = player.m_20154_();
        double offsetX = lookVec.f_82479_ * 1.8;
        double offsetY = lookVec.f_82480_ * 1.8;
        double offsetZ = lookVec.f_82481_ * 1.8;
        Vec3 playerPos = player.m_20318_(1.0f).m_82520_(offsetX, offsetY + (double)player.m_20192_(), offsetZ);
        double attackRange = 8.0;
        double sweepAngle = Math.toRadians(100.0);
        double maxDistance = 10.0;
        Vec3 playerPos2 = player.m_20182_();
        List entities = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(attackRange));
        double pushStrength = 2.0;
        double opposite = -1.0;
        player.m_5997_(lookVec.f_82479_ * opposite, lookVec.f_82480_ * opposite, lookVec.f_82481_ * opposite);
        player.f_19789_ = 0.0f;
        for (LivingEntity entity : entities) {
            if (entity == player) continue;
            Vec3 entityPos = entity.m_20182_().m_82546_(playerPos2);
            double distance = entityPos.m_82553_();
            double angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
            if (!(angle < sweepAngle / 2.0)) continue;
            double distanceMultiplier = 1.0 - Math.min(distance / maxDistance, 1.0);
            if (entity instanceof Player) {
                Player player1 = (Player)entity;
                player1.m_5997_(lookVec.f_82479_ * (pushStrength * distanceMultiplier), lookVec.f_82480_ * (pushStrength * distanceMultiplier), lookVec.f_82481_ * (pushStrength * distanceMultiplier));
                continue;
            }
            entity.m_5997_(lookVec.f_82479_ * (pushStrength * distanceMultiplier), lookVec.f_82480_ * (pushStrength * distanceMultiplier), lookVec.f_82481_ * (pushStrength * distanceMultiplier));
        }
        if (level.f_46443_) {
            level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 2.0, offsetY / 2.0, offsetZ / 2.0);
            level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 4.0, offsetY / 4.0, offsetZ / 4.0);
            level.m_7107_((ParticleOptions)ModParticleTypes.BIG_SONIC_RING.get(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, offsetX / 1.5, offsetY / 1.5, offsetZ / 1.5);
        }
    }

    public static void recoil(Player player, double force) {
        Vec3 lookVec = player.m_20154_();
        double opposite = force;
        player.m_5997_(lookVec.f_82479_ * opposite, lookVec.f_82480_ * opposite, lookVec.f_82481_ * opposite);
    }

    public static void firingSmoke(Level level, Player player) {
        Vec3 lookVec = player.m_20154_();
        double offsetX = lookVec.f_82479_ * 1.8;
        double offsetY = lookVec.f_82480_ * 1.8 + (double)player.m_20192_();
        double offsetZ = lookVec.f_82481_ * 1.8;
        Vec3 playerPos = player.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
        if (!level.f_46443_) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, 6, 0.0, 0.0, 0.0, 0.2);
        }
    }

    public static void ejectCasing(Level level, LivingEntity livingEntity) {
        Player playerEntity = (Player)livingEntity;
        ItemStack heldItem = playerEntity.m_21205_();
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        Vec3 lookVec = playerEntity.m_20154_();
        Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        Vec3 forwardVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        boolean isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)playerEntity);
        double divisor = isAiming ? 0.4 : 0.5;
        double offsetX = rightVec.f_82479_ * divisor + forwardVec.f_82479_ * divisor;
        double offsetY = (double)playerEntity.m_20192_() - 0.4;
        double offsetZ = rightVec.f_82481_ * divisor + forwardVec.f_82481_ * divisor;
        Vec3 particlePos = playerEntity.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
        ResourceLocation pistolAmmoLocation = ModItems.PISTOL_AMMO.getId();
        ResourceLocation rifleAmmoLocation = ModItems.RIFLE_AMMO.getId();
        ResourceLocation shotgunShellLocation = ModItems.SHOTGUN_SHELL.getId();
        ResourceLocation spectreAmmoLocation = ModItems.SPECTRE_ROUND.getId();
        ResourceLocation blazeAmmoLocation = ModItems.BLAZE_ROUND.getId();
        ResourceLocation projectileLocation = gun.getProjectile().getItem();
        SimpleParticleType casingType = (SimpleParticleType)ModParticleTypes.CASING_PARTICLE.get();
        if (projectileLocation != null) {
            if (projectileLocation.equals((Object)pistolAmmoLocation) || projectileLocation.equals((Object)rifleAmmoLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.CASING_PARTICLE.get();
            } else if (projectileLocation.equals((Object)shotgunShellLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.SHELL_PARTICLE.get();
            } else if (projectileLocation.equals((Object)spectreAmmoLocation)) {
                casingType = (SimpleParticleType)ModParticleTypes.SPECTRE_CASING_PARTICLE.get();
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)casingType, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            if (playerEntity.m_21205_().m_41720_().toString().matches(((GunItem)ModItems.BLOSSOM_RIFLE.get()).toString())) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.3, 0.2, 0.3, 0.0);
            }
        }
    }
}

