/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableItemEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;

@Mod.EventBusSubscriber
public class ThrowableExplosiveChargeEntity
extends ThrowableGrenadeEntity {
    private LivingEntity targetEntity;
    private boolean hasStartedRiding = false;
    private long rideStartTime;
    private int heartBeat = 20;
    private int fuse = 200;
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(ThrowableExplosiveChargeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_LANDED = SynchedEntityData.m_135353_(ThrowableExplosiveChargeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ThrowableExplosiveChargeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.setMaxLife(72000);
        this.setSticky(true);
    }

    public ThrowableExplosiveChargeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world, LivingEntity player) {
        super(entityType, world, player);
        this.setItem(new ItemStack((ItemLike)ModItems.EXPLOSIVE_CHARGE.get()));
        this.setMaxLife(72000);
        this.setSticky(true);
    }

    public ThrowableExplosiveChargeEntity(Level world, LivingEntity player, int maxCookTime) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_EXPLOSIVE_CHARGE.get()), world, player);
        this.setItem(new ItemStack((ItemLike)ModItems.EXPLOSIVE_CHARGE.get()));
        this.setMaxLife(maxCookTime);
        this.setSticky(true);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.setSticky(true);
        if (this.m_9236_().f_46443_ && this.hasLanded()) {
            this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(FUSE, (Object)this.fuse);
            this.f_19804_.m_135381_(HAS_LANDED, (Object)this.hasLanded);
        } else {
            this.fuse = (Integer)this.f_19804_.m_135370_(FUSE);
            this.hasLanded = (Boolean)this.f_19804_.m_135370_(HAS_LANDED);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.hasLanded()) {
                --this.heartBeat;
                if (this.heartBeat <= 0) {
                    this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.BEEP.get(), SoundSource.HOSTILE, 0.6f, 1.0f);
                    this.heartBeat = 20;
                }
                --this.fuse;
            }
            if (this.fuse <= 0) {
                ProjectileEntity.createExplosion((Entity)this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue() / 2.0f, false);
                this.m_146870_();
            }
        }
    }

    public void onRemovedFromWorld() {
        if (this.m_9236_().f_46443_) {
            double posX = this.m_20185_() - this.m_20184_().m_7096_();
            double posY = this.m_20186_() - this.m_20184_().m_7098_();
            double posZ = this.m_20189_() - this.m_20184_().m_7094_();
            this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.BIG_EXPLOSION.get(), true, posX, posY + 2.0, posZ, 0.0, 0.0, 0.0);
            for (int i = 0; i < 10; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SMOKE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    @Override
    public void particleTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 20) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUSE, (Object)200);
        this.f_19804_.m_135372_(HAS_LANDED, (Object)false);
    }
}

