/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai.trumpet;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.TrumpetItem;

public class TrumpetRangedAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public TrumpetRangedAttackGoal(T mob, double speedModifier, int attackIntervalMin, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int attackCooldown) {
        this.attackIntervalMin = attackCooldown;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.isHoldingTrumpet();
    }

    protected boolean isHoldingTrumpet() {
        return this.mob.m_21093_(itemStack -> itemStack.m_41720_() instanceof TrumpetItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingTrumpet();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            boolean sawTargetPreviously;
            double distanceToTarget = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target);
            boolean bl = sawTargetPreviously = this.seeTime > 0;
            if (canSeeTarget != sawTargetPreviously) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            if (distanceToTarget <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTarget > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTarget < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
            }
            if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.performTrumpetAttack(target);
                this.attackTime = this.attackIntervalMin;
            }
            double targetEyeY = target.m_20188_();
            this.mob.m_21563_().m_24946_(target.m_20185_(), targetEyeY, target.m_20189_());
            this.mob.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20191_().m_82399_());
        }
    }

    private void performTrumpetAttack(LivingEntity target) {
        this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), (SoundEvent)ModSounds.DOOT.get(), this.mob.m_5720_(), 1.0f, 1.0f);
        double knockbackStrength = 2.0;
        target.m_147240_(knockbackStrength, (double)Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))));
        this.pushEntitiesAway((Mob)this.mob, 7.0, 1.0);
        Vec3 mobPosition = this.mob.m_20182_();
        Vec3 lookVec = this.mob.m_20154_();
        double opposite = -1.0;
        this.mob.m_5997_(lookVec.f_82479_ * opposite, lookVec.f_82480_ * opposite, lookVec.f_82481_ * opposite);
        List nearbyEntities = this.mob.m_9236_().m_6249_(this.mob, this.mob.m_20191_().m_82400_(5.0), e -> e != this.mob && e instanceof LivingEntity);
        for (Entity entity : nearbyEntities) {
            Vec3 direction = entity.m_20182_().m_82546_(mobPosition).m_82541_();
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_5997_(direction.f_82479_ * 1.0, direction.f_82480_ * 1.0, direction.f_82481_ * 1.0);
        }
        this.mob.m_5997_(0.0, 0.1, 0.0);
        double offsetX = lookVec.f_82479_ * 1.8;
        double offsetY = lookVec.f_82480_ * 1.8;
        double offsetZ = lookVec.f_82481_ * 1.8;
        Vec3 skeletonPos = this.mob.m_20318_(1.0f).m_82520_(offsetX, offsetY + (double)this.mob.m_20192_(), offsetZ);
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_SONIC_RING.get()), skeletonPos.f_82479_, skeletonPos.f_82480_, skeletonPos.f_82481_, 1, offsetX / 2.0, offsetY / 2.0, offsetZ / 2.0, 0.1);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_SONIC_RING.get()), skeletonPos.f_82479_, skeletonPos.f_82480_, skeletonPos.f_82481_, 1, offsetX / 4.0, offsetY / 4.0, offsetZ / 4.0, 0.1);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_SONIC_RING.get()), skeletonPos.f_82479_, skeletonPos.f_82480_, skeletonPos.f_82481_, 1, offsetX / 1.5, offsetY / 1.5, offsetZ / 1.5, 0.1);
        }
    }

    public void pushEntitiesAway(Mob mob, double radius, double force) {
        Vec3 mobPosition = mob.m_20182_();
        List nearbyEntities = mob.m_9236_().m_6249_((Entity)mob, mob.m_20191_().m_82400_(radius), e -> e != mob && e instanceof LivingEntity);
        for (Entity entity : nearbyEntities) {
            Vec3 direction = entity.m_20182_().m_82546_(mobPosition).m_82541_();
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                continue;
            }
            livingEntity.m_5997_(direction.f_82479_ * force, direction.f_82480_ * force, direction.f_82481_ * force);
        }
    }
}

