/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.entity.ai.AIType;
import ttv.migami.jeg.entity.ai.Faction;
import ttv.migami.jeg.entity.ai.GunAttackGoal;
import ttv.migami.jeg.entity.ai.GunMobValues;
import ttv.migami.jeg.entity.ai.GunnerManager;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.item.GunItem;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunnerMobSpawner {
    public static final UUID GUN_FOLLOW_RANGE_MODIFIER_UUID = UUID.randomUUID();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onSpecialSpawn(MobSpawnEvent.FinalizeSpawn event) {
        long totalDayTime;
        int currentDay;
        Mob entity = event.getEntity();
        GunnerManager manager = new GunnerManager(GunnerManager.getConfigFactions());
        Faction faction = manager.getFactionForMob(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
        if (faction != null && (currentDay = (int)((totalDayTime = entity.m_9236_().m_46468_()) / 24000L)) >= GunMobValues.minDays) {
            int daysOverMin = currentDay - GunMobValues.minDays;
            int currentChance = Math.min(GunMobValues.initialChance + daysOverMin * GunMobValues.chanceIncrement, GunMobValues.maxChance);
            if (entity.m_217043_().m_188503_(100) < currentChance) {
                entity.m_20049_("MobGunner");
                entity.m_20049_("Unequipped");
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PathfinderMob) {
            GunnerManager manager;
            Faction faction;
            PathfinderMob mob = (PathfinderMob)livingEntity;
            ItemStack heldItem = mob.m_21205_();
            if (mob.m_19880_().contains("MobGunner") && !(heldItem.m_41720_() instanceof GunItem) && mob.f_19797_ < 2 && (faction = (manager = new GunnerManager(GunnerManager.getConfigFactions())).getFactionForMob(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()))) != null) {
                Item item;
                boolean isCloseRange = mob.m_217043_().m_188499_();
                int stopRange = isCloseRange ? 7 : 20;
                Item gun = faction.getRandomGun(isCloseRange);
                AIType[] values = AIType.values();
                AIType aiType = values[mob.m_217043_().m_188503_(values.length)];
                boolean elite = (double)mob.m_217043_().m_188501_() > GunMobValues.eliteChance && GunMobValues.elitesEnabled;
                int aiLevel = faction.getAiLevel();
                if (elite) {
                    gun = faction.getEliteGun();
                    ++aiLevel;
                }
                if (!(mob.m_9236_().f_46443_ || GunnerMobSpawner.hasGunAttackGoal(mob) || mob.m_19880_().contains("GunAttackAssigned"))) {
                    mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, stopRange, 1.2f, aiType, aiLevel));
                    mob.m_20049_("GunAttackAssigned");
                }
                Item finalGun = gun;
                if (elite) {
                    mob.m_20049_("EliteGunner");
                    mob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42354_));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, true));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 1, false, false));
                }
                GunnerMobSpawner.extendFollowRange(mob);
                ItemStack modifiedGun = new ItemStack((ItemLike)finalGun);
                mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
                if (modifiedGun.m_41783_() != null && (item = modifiedGun.m_41720_()) instanceof GunItem) {
                    GunItem gunItem = (GunItem)item;
                    Gun gunModified = gunItem.getModifiedGun(modifiedGun);
                    modifiedGun.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
                }
            }
            if (heldItem.m_41720_() instanceof GunItem && mob.f_19797_ < 2) {
                GunnerMobSpawner.reassessWeaponGoal(mob);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            ItemStack heldItem;
            PathfinderMob mob = (PathfinderMob)entity;
            if (mob.m_19880_().contains("GunAttackAssigned")) {
                mob.m_20137_("GunAttackAssigned");
            }
            if ((heldItem = mob.m_21205_()).m_41720_() instanceof GunItem) {
                GunnerMobSpawner.reassessWeaponGoal(mob);
            } else {
                GunnerMobSpawner.resetFollowRange(mob);
            }
        }
    }

    public static boolean hasGunAttackGoal(PathfinderMob mob) {
        return mob.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof GunAttackGoal);
    }

    public static void reassessWeaponGoal(PathfinderMob mob) {
        if (!mob.m_9236_().f_46443_) {
            if (!GunnerMobSpawner.hasGunAttackGoal(mob) && !mob.m_19880_().contains("GunAttackAssigned")) {
                AIType[] values = AIType.values();
                AIType aiType = values[mob.m_217043_().m_188503_(values.length)];
                boolean isCloseRange = mob.m_217043_().m_188499_();
                int stopRange = isCloseRange ? 7 : 20;
                int aiDifficulty = mob.m_217043_().m_188503_(4) + 1;
                mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, stopRange, 1.2f, aiType, aiDifficulty));
                mob.m_20049_("GunAttackAssigned");
            }
            GunnerMobSpawner.extendFollowRange(mob);
        }
    }

    public static void extendFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            AttributeModifier modifier = new AttributeModifier(GUN_FOLLOW_RANGE_MODIFIER_UUID, "Gun follow range modifier", 64.0 - mob.m_21051_(Attributes.f_22277_).m_22115_(), AttributeModifier.Operation.ADDITION);
            if (!mob.m_21051_(Attributes.f_22277_).m_22109_(modifier)) {
                mob.m_21051_(Attributes.f_22277_).m_22125_(modifier);
            }
        }
    }

    public static void resetFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            mob.m_21051_(Attributes.f_22277_).m_22120_(GUN_FOLLOW_RANGE_MODIFIER_UUID);
        }
    }
}

