/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.entity.ai.Faction;

public class GunnerManager {
    private final Map<String, Faction> factions = new HashMap<String, Faction>();
    static List<String> gunnerMobsList = null;

    public static void init() {
        gunnerMobsList = new ArrayList<String>((Collection)Config.COMMON.gunnerMobs.factions.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registered the following Factions: {}", gunnerMobsList);
    }

    public static List<String> getConfigFactions() {
        return gunnerMobsList;
    }

    public GunnerManager(List<? extends String> factionConfig) {
        for (String string : factionConfig) {
            String[] parts = string.split("\\|");
            if (parts.length != 6) continue;
            String name = parts[0];
            int aiLevel = Integer.parseInt(parts[1]);
            List<String> mobs = Arrays.asList(parts[2].split(","));
            List<Item> closeGuns = Arrays.stream(parts[3].split(",")).map(gunName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(gunName))).filter(Objects::nonNull).toList();
            List<Item> longGuns = Arrays.stream(parts[4].split(",")).map(gunName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(gunName))).filter(Objects::nonNull).toList();
            List<Item> eliteGuns = Arrays.stream(parts[5].split(",")).map(gunName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(gunName))).filter(Objects::nonNull).toList();
            this.factions.put(name, new Faction(name, aiLevel, mobs, closeGuns, longGuns, eliteGuns));
        }
    }

    public Faction getFactionForMob(ResourceLocation entityType) {
        return this.factions.values().stream().filter(f -> f.getMobs().contains(entityType.toString())).findFirst().orElse(null);
    }

    public Faction getFactionByName(String factionName) {
        return this.getFactions().stream().filter(f -> f.getName().equalsIgnoreCase(factionName)).findFirst().orElse(null);
    }

    public Collection<Faction> getFactions() {
        return this.factions.values();
    }
}

