/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.ai.AIGunEvent;
import ttv.migami.jeg.entity.ai.AIType;
import ttv.migami.jeg.event.GunEventBus;
import ttv.migami.jeg.init.ModEffects;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageGunSound;

public class GunAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final T shooter;
    protected final double speedModifier;
    protected int seeTime;
    protected int attackTime;
    protected final float attackRadiusSqr;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected int strafingTime;
    protected int burstIntervalTimer = 0;
    protected int remainingBursts = 0;
    protected int burstResetTimer = 0;
    protected int reloadTick = 0;
    protected boolean isReloading = false;
    protected boolean isPanicked = false;
    protected int panickTimer = 0;
    protected AIType aiType = AIType.TACTICAL;
    protected Vec3 lastKnownPosition;
    protected float spreadModifier = 10.0f;
    protected int burstAmount = 3;
    protected int burstTimer = 20;

    public GunAttackGoal(T shooter, double stopRange, float speedModifier, AIType aiType, int difficulty) {
        this.shooter = shooter;
        this.speedModifier = speedModifier;
        this.attackTime = -1;
        this.attackRadiusSqr = (float)(stopRange * stopRange);
        this.aiType = aiType;
        if (this.shooter.m_5448_() != null) {
            this.lastKnownPosition = this.shooter.m_5448_().m_20182_();
        }
        this.spreadModifier /= (float)difficulty;
        this.burstAmount *= difficulty;
        this.burstTimer /= difficulty;
    }

    public boolean m_8036_() {
        return this.shooter.m_5448_() != null && this.isHoldingGun() && !this.shooter.m_5448_().m_21224_();
    }

    protected boolean isHoldingGun() {
        return this.shooter.m_21093_(itemStack -> itemStack.m_41720_() instanceof GunItem);
    }

    public void m_8056_() {
        super.m_8056_();
        this.shooter.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.shooter.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.shooter.m_5810_();
        this.reloadTick = 0;
        this.isReloading = false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Item item;
        LivingEntity target = this.shooter.m_5448_();
        ItemStack heldItem = this.shooter.m_21205_();
        if (this.shooter.m_21023_((MobEffect)ModEffects.BLINDED.get()) || this.shooter.m_21023_((MobEffect)ModEffects.DEAFENED.get())) {
            this.isPanicked = true;
        }
        if (target != null && (item = heldItem.m_41720_()) instanceof GunItem) {
            Level level;
            Vec3 flankingPosition;
            boolean sawTargetPreviously;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            double distanceToTarget = this.shooter.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSeeTarget = this.shooter.m_21574_().m_148306_((Entity)target);
            boolean bl = sawTargetPreviously = this.seeTime > 0;
            if (canSeeTarget != sawTargetPreviously) {
                this.seeTime = 0;
            }
            if (this.isReloading) {
                ++this.seeTime;
            } else if (canSeeTarget) {
                this.lastKnownPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                ++this.seeTime;
            } else {
                if (this.aiType == AIType.TACTICAL && this.lastKnownPosition != null && (flankingPosition = this.findFlankingPosition(this.lastKnownPosition, target)) != null) {
                    this.shooter.m_21573_().m_26519_(flankingPosition.f_82479_, flankingPosition.f_82480_, flankingPosition.f_82481_, this.speedModifier);
                }
                --this.seeTime;
            }
            if (this.aiType == AIType.COWARD && (this.shooter.m_21223_() < this.shooter.m_21233_() / 3.0f || ((PathfinderMob)this.shooter).f_19802_ != 0)) {
                this.isPanicked = true;
                this.panickTimer = 20;
            }
            if (this.isPanicked) {
                Vec3 vec3 = DefaultRandomPos.m_148403_(this.shooter, (int)5, (int)4);
                if (vec3 != null) {
                    this.shooter.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
                }
                --this.panickTimer;
            }
            if (this.panickTimer <= 0) {
                this.isPanicked = false;
            }
            if (heldItem.m_41783_().m_128451_("AmmoCount") <= 0) {
                if (!this.isReloading) {
                    if (this.aiType != AIType.RECKLESS) {
                        Vec3 coverLocation = this.findCoverLocation();
                        this.shooter.m_21573_().m_26519_(coverLocation.f_82479_, coverLocation.f_82480_, coverLocation.f_82481_, 1.2);
                    }
                    this.isReloading = true;
                    this.reloadTick = gun.getReloads().getReloadTimer();
                    this.shooter.m_9236_().m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)ModSounds.ITEM_PISTOL_RELOAD.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                } else if (this.reloadTick == 0) {
                    heldItem.m_41783_().m_128405_("AmmoCount", gun.getReloads().getMaxAmmo());
                    this.shooter.m_9236_().m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.isReloading = false;
                } else {
                    --this.reloadTick;
                }
            }
            if ((double)this.shooter.m_9236_().f_46441_.m_188501_() < 0.1 && this.aiType == AIType.TACTICAL && (flankingPosition = this.findFlankingPosition(this.lastKnownPosition, target)) != null) {
                this.shooter.m_21573_().m_26519_(flankingPosition.f_82479_, flankingPosition.f_82480_, flankingPosition.f_82481_, this.speedModifier);
            }
            if (!this.isReloading && !this.isPanicked) {
                if (distanceToTarget <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                    this.shooter.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else if (this.aiType == AIType.RECKLESS) {
                    this.shooter.m_21573_().m_5624_((Entity)target, this.speedModifier);
                    this.strafingTime = -1;
                } else {
                    this.shooter.m_21573_().m_5624_((Entity)target, 1.0);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.shooter.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.shooter.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distanceToTarget > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (distanceToTarget < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.shooter.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                if (this.shooter.m_21205_().m_41783_().m_128451_("AmmoCount") > 0 && --this.attackTime <= 0 && this.seeTime >= -20 && this.seeTime >= 10) {
                    if (this.remainingBursts <= 0 && this.burstResetTimer <= 0) {
                        this.remainingBursts = 1 + this.shooter.m_9236_().f_46441_.m_188503_(this.burstAmount);
                        this.burstIntervalTimer = 1 + this.shooter.m_9236_().f_46441_.m_188503_(this.burstTimer);
                        this.burstResetTimer = 20 + this.shooter.m_9236_().f_46441_.m_188503_(40);
                    }
                    if (this.remainingBursts > 0 && --this.burstIntervalTimer <= 0) {
                        this.shoot(target, gun);
                        --this.remainingBursts;
                        this.burstIntervalTimer = 1 + this.shooter.m_9236_().f_46441_.m_188503_(10);
                    }
                    if (this.remainingBursts <= 0) {
                        --this.burstResetTimer;
                    }
                }
                double targetEyeY = target.m_20188_();
                this.shooter.m_21563_().m_24946_(target.m_20185_(), targetEyeY, target.m_20189_());
                this.shooter.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20191_().m_82399_());
                if (this.shooter.m_21205_().m_41720_() == ModItems.BOLT_ACTION_RIFLE.get() && this.shooter.m_5448_() != null && canSeeTarget) {
                    Vec3 userPos = this.shooter.m_20318_(1.0f).m_82520_(0.0, (double)this.shooter.m_5448_().m_20192_() / 1.25, 0.0);
                    Vec3 targetPos = this.shooter.m_5448_().m_20318_(1.0f).m_82520_(0.0, (double)(this.shooter.m_5448_().m_20192_() / 2.0f), 0.0);
                    Vec3 distanceTo = targetPos.m_82546_(userPos);
                    Vec3 normal = distanceTo.m_82541_();
                    if (!this.shooter.m_9236_().m_5776_()) {
                        for (float i = 1.0f; i < (float)Mth.m_14107_((double)distanceTo.m_82553_()); i += 0.2f) {
                            Vec3 vec33 = userPos.m_82549_(normal.m_82490_((double)i));
                            Level level2 = this.shooter.m_9236_();
                            if (!(level2 instanceof ServerLevel)) continue;
                            ServerLevel serverLevel = (ServerLevel)level2;
                            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.ENTITY_LASER.get(), true, vec33.m_7096_(), vec33.m_7098_(), vec33.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.aiType == AIType.TACTICAL && !this.isPanicked && !this.isReloading) {
                double targetEyeY = target.m_20188_();
                this.shooter.m_21563_().m_24946_(target.m_20185_(), targetEyeY, target.m_20189_());
                this.shooter.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20191_().m_82399_());
            }
            if (this.isReloading && heldItem.m_41783_().m_128451_("AmmoCount") <= 0 && (level = this.shooter.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BUBBLE_AMMO.get()), this.shooter.m_20185_(), this.shooter.m_20186_() + ((double)this.shooter.m_20192_() + 0.9), this.shooter.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void shoot(LivingEntity target, Gun gun) {
        ItemStack heldItem = this.shooter.m_21205_();
        if (heldItem.m_41720_() == ModItems.SUPERSONIC_SHOTGUN.get()) {
            GunEventBus.soundwaveBlast(this.shooter.m_9236_(), this.shooter, Gun.getAdditionalDamage(heldItem), gun);
        } else {
            AIGunEvent.performGunAttack(this.shooter, heldItem, gun, this.spreadModifier);
        }
        this.attackTime = gun.getGeneral().getRate();
        this.consumeAmmo(heldItem);
        ResourceLocation fireSound = gun.getSounds().getFire();
        if (fireSound != null) {
            double posX = this.shooter.m_20185_();
            double posY = this.shooter.m_20186_() + (double)this.shooter.m_20192_();
            double posZ = this.shooter.m_20189_();
            float volume = 16.0f;
            float pitch = 0.9f + this.shooter.m_9236_().f_46441_.m_188501_() * 0.2f;
            double radius = (Double)Config.SERVER.gunShotMaxDistance.get();
            boolean muzzle = gun.getDisplay().getFlash() != null;
            S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, this.shooter.m_19879_(), muzzle, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)this.shooter.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
        }
    }

    private void consumeAmmo(ItemStack itemStack) {
        itemStack.m_41783_().m_128405_("AmmoCount", itemStack.m_41783_().m_128451_("AmmoCount") - 1);
    }

    private Vec3 findFlankingPosition(Vec3 lastKnownPosition, LivingEntity target) {
        Vec3 mobPos = this.shooter.m_20182_();
        if (lastKnownPosition == null) {
            return null;
        }
        Vec3 directionToTarget = lastKnownPosition.m_82546_(mobPos).m_82541_();
        for (int i = 0; i < 5; ++i) {
            Vec3 offset = directionToTarget.m_82537_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())).m_82490_(3.0).m_82549_(this.randomOffset());
            Vec3 flankingPosition = mobPos.m_82549_(offset);
            if (!this.shooter.m_9236_().m_8055_(BlockPos.m_274446_((Position)flankingPosition)).m_60795_() || !this.shooter.m_21574_().m_148306_((Entity)target)) continue;
            return flankingPosition;
        }
        return null;
    }

    private Vec3 randomOffset() {
        return new Vec3(this.shooter.m_217043_().m_188500_() - 0.5, 0.0, this.shooter.m_217043_().m_188500_() - 0.5).m_82490_(1.5);
    }

    private Vec3 findCoverLocation() {
        Vec3 targetPos = new Vec3(this.shooter.m_5448_().m_20185_(), this.shooter.m_5448_().m_20186_(), this.shooter.m_5448_().m_20189_());
        Vec3 mobPos = this.shooter.m_20182_();
        return mobPos.m_82549_(mobPos.m_82546_(targetPos).m_82541_().m_82490_(3.0));
    }
}

