/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ProjectileManager;
import ttv.migami.jeg.common.SpreadTracker;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.interfaces.IProjectileFactory;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageBulletTrail;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class AIGunEvent {
    public static void performGunAttack(Mob shooter, ItemStack itemStack, Gun modifiedGun, float spreadModifier) {
        Level level = shooter.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        int count = modifiedGun.getGeneral().getProjectileAmount();
        Gun.Projectile projectileProps = modifiedGun.getProjectile();
        ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
        for (int i = 0; i < count; ++i) {
            IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
            ProjectileEntity projectileEntity = factory.create(level, (LivingEntity)shooter, itemStack, (GunItem)itemStack.m_41720_(), modifiedGun);
            projectileEntity.setWeapon(itemStack);
            projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(itemStack));
            Vec3 dir = AIGunEvent.getDirection((LivingEntity)shooter, itemStack, (GunItem)itemStack.m_41720_(), modifiedGun, spreadModifier);
            double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(itemStack);
            double speed = GunModifierHelper.getModifiedProjectileSpeed(itemStack, projectileEntity.getProjectile().getSpeed() * speedModifier);
            projectileEntity.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
            projectileEntity.updateHeading();
            double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
            double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
            double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
            projectileEntity.m_6034_(posX, posY, posZ);
            level.m_7967_((Entity)projectileEntity);
            spawnedProjectiles[i] = projectileEntity;
            projectileEntity.m_8119_();
        }
        if (!projectileProps.isVisible()) {
            int radius = (int)shooter.m_20185_();
            int y1 = (int)(shooter.m_20186_() + 1.0);
            int z1 = (int)shooter.m_20189_();
            double r = (Double)Config.COMMON.network.projectileTrackingRange.get();
            ParticleOptions data = GunEnchantmentHelper.getParticle(itemStack);
            boolean isVisible = !modifiedGun.getProjectile().hideTrail();
            S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, shooter.m_19879_(), data, isVisible);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)level, (double)radius, (double)y1, (double)z1, (double)r), (IMessage)messageBulletTrail);
        }
    }

    public static Vec3 getDirection(LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun, float spreadModifier) {
        float gunSpread = GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getGeneral().getSpread());
        if (gunSpread == 0.0f) {
            return AIGunEvent.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (shooter instanceof Player) {
            if (!modifiedGun.getGeneral().isAlwaysSpread()) {
                gunSpread *= SpreadTracker.get((Player)shooter).getSpread(item);
            }
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)((Player)shooter))).booleanValue()) {
                gunSpread *= 0.5f;
            }
        } else if ((gunSpread *= shooter.m_9236_().m_46791_() != Difficulty.HARD ? spreadModifier * 2.0f : spreadModifier) > 60.0f) {
            gunSpread = 60.0f;
        }
        gunSpread = Math.min(gunSpread, 170.0f) * 0.5f * ((float)Math.PI / 180);
        Vec3 vecforwards = AIGunEvent.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        Vec3 vecupwards = AIGunEvent.getVectorFromRotation(shooter.m_146909_() + 90.0f, shooter.m_146908_());
        Vec3 vecsideways = vecforwards.m_82537_(vecupwards);
        float theta = shooter.m_9236_().f_46441_.m_188501_() * 2.0f * (float)Math.PI;
        float r = Mth.m_14116_((float)shooter.m_9236_().f_46441_.m_188501_()) * (float)Math.tan(gunSpread);
        float a1 = Mth.m_14089_((float)theta) * r;
        float a2 = Mth.m_14031_((float)theta) * r;
        return vecforwards.m_82549_(vecsideways.m_82490_((double)a1)).m_82549_(vecupwards.m_82490_((double)a2)).m_82541_();
    }

    private static Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }
}

