/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ProjectileManager;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.common.ShootTracker;
import ttv.migami.jeg.common.SpreadTracker;
import ttv.migami.jeg.common.container.AbstractWorkbenchContainer;
import ttv.migami.jeg.common.container.AttachmentContainer;
import ttv.migami.jeg.common.container.BlueprintWorkbenchContainer;
import ttv.migami.jeg.common.container.GunmetalWorkbenchContainer;
import ttv.migami.jeg.common.container.GunniteWorkbenchContainer;
import ttv.migami.jeg.common.container.ScrapWorkbenchContainer;
import ttv.migami.jeg.crafting.workbench.AbstractWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.BlueprintWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.GunmetalWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.GunniteWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.ScrapWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.WorkbenchRecipes;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.event.BurstFireEvent;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModRecipeTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.interfaces.IProjectileFactory;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessagePreFireSound;
import ttv.migami.jeg.network.message.C2SMessageShoot;
import ttv.migami.jeg.network.message.S2CMessageBulletTrail;
import ttv.migami.jeg.network.message.S2CMessageGunSound;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> (entity.m_5720_() == SoundSource.HOSTILE || entity.m_6095_() == EntityType.f_20511_ || entity.m_6095_() == EntityType.f_20531_) && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    private static final Predicate<LivingEntity> FLEEING_ENTITIES = entity -> ((List)Config.COMMON.fleeingMobs.fleeingEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());

    public static BlockPos rayTrace(Player pPlayer, double distance) {
        HitResult rayTraceResult = pPlayer.m_19907_(distance, 1.0f, false);
        return BlockPos.m_274446_((Position)rayTraceResult.m_82450_());
    }

    public static EntityHitResult hitEntity(Level pLevel, Player pPlayer, BlockPos blockPos) {
        return ProjectileUtil.m_37304_((Level)pLevel, (Entity)pPlayer, (Vec3)pPlayer.m_146892_(), (Vec3)blockPos.m_252807_(), (AABB)new AABB(pPlayer.m_146892_(), blockPos.m_252807_()), ServerPlayHandler::canDamage);
    }

    public static boolean canDamage(Entity entity) {
        return entity instanceof LivingEntity;
    }

    public static void unjam(Player player) {
        ItemStack itemStack = player.m_21205_();
        CompoundTag nbtCompound = itemStack.m_41784_();
        if (itemStack.m_41720_() instanceof AnimatedGunItem) {
            nbtCompound.m_128473_("IsJammed");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleShoot(C2SMessageShoot message, ServerPlayer player) {
        int level;
        CompoundTag tag;
        ResourceLocation fireSound;
        Gun modifiedGun;
        GunItem item;
        ItemStack heldItem;
        Level world;
        block20: {
            Iterator iterator;
            double fleeRadiusSquared;
            double aggroRadiusSquared;
            double z;
            double y;
            double x;
            block21: {
                block19: {
                    if (player.m_5833_()) {
                        return;
                    }
                    if (player.m_21211_().m_41720_() instanceof ShieldItem) {
                        return;
                    }
                    world = player.m_9236_();
                    heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                    Item item2 = heldItem.m_41720_();
                    if (!(item2 instanceof GunItem)) break block19;
                    item = (GunItem)item2;
                    if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) break block19;
                    modifiedGun = item.getModifiedGun(heldItem);
                    if (modifiedGun == null) return;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
                        return;
                    }
                    player.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
                    player.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
                    ShootTracker tracker = ShootTracker.getShootTracker((Player)player);
                    if (tracker.hasCooldown(item) && tracker.getRemaining(item) > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
                        JustEnoughGuns.LOGGER.warn(player.m_7755_().m_214077_() + "(" + player.m_20148_() + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining(item));
                        return;
                    }
                    tracker.putCooldown(heldItem, item, modifiedGun);
                    if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    }
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((Player)player).update((Player)player, item);
                    }
                    if (modifiedGun.getProjectile().hasProjectile()) {
                        int count = modifiedGun.getGeneral().getProjectileAmount();
                        Gun.Projectile projectileProps = modifiedGun.getProjectile();
                        ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                        for (int i = 0; i < count; ++i) {
                            IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                            ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun);
                            projectileEntity.setWeapon(heldItem);
                            projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                            world.m_7967_((Entity)projectileEntity);
                            spawnedProjectiles[i] = projectileEntity;
                            projectileEntity.m_8119_();
                        }
                        if (!modifiedGun.getProjectile().hideTrail() && !projectileProps.isVisible()) {
                            double spawnX = player.m_20185_();
                            double spawnY = player.m_20186_() + 1.0;
                            double spawnZ = player.m_20189_();
                            double radius = (Double)Config.COMMON.network.projectileTrackingRange.get();
                            ParticleOptions data = GunEnchantmentHelper.getParticle(heldItem);
                            boolean isVisible = !modifiedGun.getProjectile().hideTrail();
                            S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, player.m_19879_(), data, isVisible);
                            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius), (IMessage)messageBulletTrail);
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
                    x = player.m_20185_();
                    y = player.m_20186_() + 0.5;
                    z = player.m_20189_();
                    double aggroRadius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.unsilencedRange.get());
                    double fleeRadius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.fleeingMobs.unsilencedRange.get());
                    boolean isSilenced = Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.SILENCER.get() || modifiedGun.getGeneral().isSilenced();
                    AABB combinedBox = new AABB(x - Math.max(aggroRadius, fleeRadius), y - Math.max(aggroRadius, fleeRadius), z - Math.max(aggroRadius, fleeRadius), x + Math.max(aggroRadius, fleeRadius), y + Math.max(aggroRadius, fleeRadius), z + Math.max(aggroRadius, fleeRadius));
                    aggroRadiusSquared = aggroRadius * aggroRadius;
                    fleeRadiusSquared = fleeRadius * fleeRadius;
                    if (isSilenced || !((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue() && !((Boolean)Config.COMMON.fleeingMobs.enabled.get()).booleanValue()) break block20;
                    List allEntities = world.m_45976_(LivingEntity.class, combinedBox);
                    iterator = allEntities.iterator();
                    break block21;
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
                return;
            }
            while (iterator.hasNext()) {
                Wolf wolf;
                Mob mob;
                LivingEntity entity = (LivingEntity)iterator.next();
                double dx = x - entity.m_20185_();
                double dy = y - entity.m_20186_();
                double dz = z - entity.m_20189_();
                double distanceSquared = dx * dx + dy * dy + dz * dz;
                if (((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue() && distanceSquared <= aggroRadiusSquared && HOSTILE_ENTITIES.test(entity)) {
                    if (entity instanceof ZombifiedPiglin) {
                        ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)entity;
                        zombifiedPiglin.m_6925_(player.m_20148_());
                        zombifiedPiglin.m_7870_(400 + world.f_46441_.m_188503_(400));
                    } else if (entity instanceof Piglin) {
                        Piglin piglin = (Piglin)entity;
                        piglin.m_6710_((LivingEntity)player);
                        piglin.m_21561_(true);
                    } else {
                        entity.m_6703_((LivingEntity)player);
                    }
                }
                if (!((Boolean)Config.COMMON.fleeingMobs.enabled.get()).booleanValue() || !(distanceSquared <= fleeRadiusSquared) || !FLEEING_ENTITIES.test(entity) || !(entity instanceof Mob) || (mob = (Mob)entity) instanceof Wolf && ((wolf = (Wolf)mob).m_21824_() || wolf.m_21825_())) continue;
                mob.m_6274_().m_21936_(MemoryModuleType.f_26381_);
                mob.m_6274_().m_21936_(MemoryModuleType.f_26382_);
                mob.m_21573_().m_26573_();
                double speedMultiplier = entity.m_6095_() == EntityType.f_20492_ ? 1.2 : 1.0;
                PanicGoal panicGoal = new PanicGoal((PathfinderMob)mob, speedMultiplier);
                mob.f_21345_.m_25352_(1, (Goal)panicGoal);
                panicGoal.m_8056_();
                mob.f_21345_.m_25363_((Goal)panicGoal);
            }
        }
        if ((fireSound = ServerPlayHandler.getFireSound(heldItem, modifiedGun)) != null) {
            double posX = player.m_20185_();
            double posY = player.m_20186_() + (double)player.m_20192_();
            double posZ = player.m_20189_();
            float volume = GunModifierHelper.getFireSoundVolume(heldItem);
            float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
            double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
            boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
            S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), muzzle, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
        }
        if (Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.TRUMPET.get()) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.DOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.m_9236_().f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
            tag.m_128405_("AmmoCount", Math.max(0, tag.m_128451_("AmmoCount") - 1));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
    }

    public static void handlePreFireSound(C2SMessagePreFireSound message, ServerPlayer player) {
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            Gun modifiedGun;
            ResourceLocation fireSound;
            GunItem item2 = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && (fireSound = ServerPlayHandler.getPreFireSound(heldItem, modifiedGun = item2.getModifiedGun(heldItem))) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_() + (double)player.m_20192_();
                double posZ = player.m_20189_();
                float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), false, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
            }
        }
    }

    public static void handleBurst(ServerPlayer player) {
        GunItem gunItem;
        Gun gun;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            BurstFireEvent.resetBurst(heldItem);
        }
    }

    public static ResourceLocation getFireSound(ItemStack stack, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(stack)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (stack.m_41793_() && ((Boolean)Config.CLIENT.sounds.enchantSound.get()).booleanValue()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return modifiedGun.getSounds().getFire();
    }

    public static ResourceLocation getPreFireSound(ItemStack stack, Gun modifiedGun) {
        return modifiedGun.getSounds().getPreFire();
    }

    public static <T extends ParticleOptions> void sendParticlesToAll(ServerLevel serverLevel, T particleType, boolean longDistance, double posX, double posY, double posZ, int particleCount, double offsetX, double offsetY, double offsetZ, double speed) {
        for (ServerPlayer player : serverLevel.m_6907_()) {
            serverLevel.m_8624_(player, particleType, longDistance, posX, posY, posZ, particleCount, offsetX, offsetY, offsetZ, speed);
        }
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        ItemStack stack;
        Object recipe;
        AbstractWorkbenchContainer workbench;
        Level world = player.m_9236_();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ScrapWorkbenchContainer && (workbench = (ScrapWorkbenchContainer)abstractContainerMenu).getPos().equals((Object)pos)) {
            recipe = (ScrapWorkbenchRecipe)WorkbenchRecipes.getRecipeById(world, id, (RecipeType)ModRecipeTypes.SCRAP_WORKBENCH.get());
            if (recipe == null || !((AbstractWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((AbstractWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            stack = ((AbstractWorkbenchRecipe)recipe).getItem();
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        if ((recipe = player.f_36096_) instanceof GunmetalWorkbenchContainer && (workbench = (GunmetalWorkbenchContainer)((Object)recipe)).getPos().equals((Object)pos)) {
            recipe = (GunmetalWorkbenchRecipe)WorkbenchRecipes.getRecipeById(world, id, (RecipeType)ModRecipeTypes.GUNMETAL_WORKBENCH.get());
            if (recipe == null || !((AbstractWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((AbstractWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            stack = ((AbstractWorkbenchRecipe)recipe).getItem();
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        if ((recipe = player.f_36096_) instanceof GunniteWorkbenchContainer && (workbench = (GunniteWorkbenchContainer)((Object)recipe)).getPos().equals((Object)pos)) {
            recipe = (GunniteWorkbenchRecipe)WorkbenchRecipes.getRecipeById(world, id, (RecipeType)ModRecipeTypes.GUNNITE_WORKBENCH.get());
            if (recipe == null || !((AbstractWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((AbstractWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            stack = ((AbstractWorkbenchRecipe)recipe).getItem();
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        if ((recipe = player.f_36096_) instanceof BlueprintWorkbenchContainer && (workbench = (BlueprintWorkbenchContainer)((Object)recipe)).getPos().equals((Object)pos)) {
            recipe = (BlueprintWorkbenchRecipe)WorkbenchRecipes.getRecipeById(world, id, (RecipeType)ModRecipeTypes.BLUEPRINT_WORKBENCH.get());
            if (recipe == null || !((AbstractWorkbenchRecipe)recipe).hasMaterials((Player)player)) {
                return;
            }
            ((AbstractWorkbenchRecipe)recipe).consumeMaterials((Player)player);
            stack = ((AbstractWorkbenchRecipe)recipe).getItem();
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
    }

    public static void stopSprinting(Player player) {
        player.m_6858_(false);
        if (player.m_9236_().f_46443_) {
            Minecraft.m_91087_().f_91066_.f_92091_.m_7249_(false);
        }
    }

    public static void handleCharge(Player player, Entity entity, float damage, float currentDamage, float maxDamage, ItemStack bayonet) {
        float finalDamage = damage;
        double sweepAngle = Math.toRadians(100.0);
        Vec3 playerPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        Vec3 entityPos = entity.m_20182_().m_82546_(playerPos);
        double angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
        if (angle < sweepAngle / 3.0 && entity != player && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target.f_19802_ == 0) {
                Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                player.f_19802_ = 40;
                if (GunModifierHelper.getSwordSweepingEdge(player) < 2) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false));
                }
                target.m_5997_(direction.f_82479_ * (double)GunModifierHelper.getSwordKnockBack(player), 0.5, direction.f_82481_ * (double)GunModifierHelper.getSwordKnockBack(player));
                if ((double)currentDamage <= (double)maxDamage / 1.5) {
                    Level level;
                    target.m_6469_(player.m_269291_().m_269075_(player), GunModifierHelper.getSwordDamage(player) / 1.5f);
                    player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    if (GunModifierHelper.getSwordFireAspect(player) > 0) {
                        entity.m_20254_(2 * GunModifierHelper.getSwordFireAspect(player));
                    }
                    if ((level = player.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (int)finalDamage, 0.3, (double)entity.m_20206_(), 0.3, 0.2);
                    }
                } else {
                    player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                }
                Vec3 pushBackDirection = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                double pushBackForce = 1.0;
                if (GunModifierHelper.getSwordSweepingEdge(player) < 3) {
                    player.m_5997_(pushBackDirection.f_82479_ * pushBackForce, 0.5, pushBackDirection.f_82481_ * pushBackForce);
                }
                if (!player.m_150110_().f_35937_ && ((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() && (double)currentDamage <= (double)maxDamage / 1.5 && bayonet.getEnchantmentLevel(Enchantments.f_44962_) == 0) {
                    bayonet.m_41622_(15, (LivingEntity)player, null);
                }
            }
        }
    }

    public static void handleMelee(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        ItemCooldowns tracker = player.m_36335_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (!tracker.m_41519_(stack.m_41720_())) {
                ItemStack flashlight;
                Level level = player.m_9236_();
                if (gunItem instanceof AnimatedGunItem) {
                    AnimatedGunItem animatedGunItem = (AnimatedGunItem)gunItem;
                    long id = GeoItem.getId((ItemStack)stack);
                    AnimationController animationController = (AnimationController)animatedGunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                    if (animationController.getCurrentAnimation() != null && animationController.getCurrentAnimation().animation().name().matches("draw")) {
                        return;
                    }
                    animationController.forceAnimationReset();
                    if (Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_() instanceof SwordItem) {
                        animationController.tryTriggerAnimation("bayonet");
                    } else {
                        animationController.tryTriggerAnimation("melee");
                    }
                }
                if (Gun.hasAttachmentEquipped(player.m_21205_(), IAttachment.Type.SIDE) && Gun.getAttachment(IAttachment.Type.SIDE, player.m_21205_()).m_41720_() == ModItems.FLASHLIGHT.get() && (flashlight = Gun.getAttachment(IAttachment.Type.SIDE, player.m_21205_())).m_41783_() != null) {
                    flashlight.m_41783_().m_128379_("Powered", !flashlight.m_41783_().m_128471_("Powered"));
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.FLASHLIGHT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ItemStack bayonet = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_());
                int maxDamage = bayonet.m_41776_();
                int currentDamage = bayonet.m_41773_();
                double attackRange = 2.0;
                double sweepAngle = Math.toRadians(100.0);
                Vec3 playerPos = player.m_20182_();
                Vec3 lookVec = player.m_20154_();
                List entities = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(attackRange));
                level.m_5594_(null, player.m_20097_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
                int cooldown = 15;
                if (player.m_20142_()) {
                    cooldown = 40;
                }
                tracker.m_41524_(stack.m_41720_(), cooldown);
                for (LivingEntity entity : entities) {
                    Vec3 entityPos = entity.m_20182_().m_82546_(playerPos);
                    double angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
                    if (!(angle < sweepAngle / 2.0) || entity == player || player.m_9236_().f_46443_) continue;
                    Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                    entity.m_5997_(direction.f_82479_ * (double)GunModifierHelper.getSwordKnockBack((Player)player), 0.5, direction.f_82481_ * (double)GunModifierHelper.getSwordKnockBack((Player)player));
                    if ((double)currentDamage <= (double)maxDamage / 1.5) {
                        entity.m_6469_(player.m_269291_().m_269075_((Player)player), GunModifierHelper.getSwordDamage((Player)player) / 1.5f);
                        if (GunModifierHelper.getSwordFireAspect((Player)player) > 0) {
                            entity.m_20254_(2 * GunModifierHelper.getSwordFireAspect((Player)player));
                        }
                    } else {
                        level.m_5594_((Player)player, player.m_20097_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                    }
                    if (player.m_150110_().f_35937_ || !((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() || !((double)currentDamage <= (double)maxDamage / 1.5) || bayonet.getEnchantmentLevel(Enchantments.f_44962_) != 0) continue;
                    bayonet.m_41622_(8, (LivingEntity)player, null);
                }
                double offsetX = lookVec.f_82479_ * 1.8;
                double offsetY = lookVec.f_82480_ * 1.8 + (double)player.m_20192_();
                double offsetZ = lookVec.f_82481_ * 1.8;
                playerPos = player.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123766_, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void handleUnload(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (gun.getReloads().getReloadType() != ReloadType.SINGLE_ITEM && tag != null && tag.m_128425_("AmmoCount", 3)) {
                int count = tag.m_128451_("AmmoCount");
                tag.m_128405_("AmmoCount", 0);
                ResourceLocation id = gun.getProjectile().getItem();
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item2 == null) {
                    return;
                }
                int maxStackSize = item2.m_41459_();
                int stacks = count / maxStackSize;
                if (player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) == 0) {
                    for (int i = 0; i < stacks; ++i) {
                        ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, maxStackSize));
                    }
                    int remaining = count % maxStackSize;
                    if (remaining > 0) {
                        ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, remaining));
                    }
                }
            }
        }
    }

    public static void handleExtraAmmo(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            int currentAmmo;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("AmmoCount", 3) && (currentAmmo = tag.m_128451_("AmmoCount")) > GunModifierHelper.getModifiedAmmoCapacity(stack, gun)) {
                ResourceLocation id = gun.getProjectile().getItem();
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item2 == null) {
                    return;
                }
                int residue = currentAmmo - gun.getReloads().getMaxAmmo();
                tag.m_128405_("AmmoCount", currentAmmo - residue);
                ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, residue));
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"container.jeg.attachments")));
        }
    }
}

