/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.client.handler.ControllerHandler;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.compat.PlayerReviveHelper;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageBurst;
import ttv.migami.jeg.network.message.C2SMessagePreFireSound;
import ttv.migami.jeg.network.message.C2SMessageShoot;
import ttv.migami.jeg.network.message.C2SMessageShooting;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class ShootingHandler {
    private static ShootingHandler instance;
    private int fireTimer;
    private boolean shooting;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    private ShootingHandler() {
    }

    public boolean isShooting() {
        return this.shooting;
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack heldItem;
        Item item;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem2 = player.m_21205_();
            Item item2 = heldItem2.m_41720_();
            if (item2 instanceof GunItem) {
                GunItem gunItem = (GunItem)item2;
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        } else if (event.isUseItem() && (item = (heldItem = player.m_21205_()).m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (event.getHand() == InteractionHand.OFF_HAND) {
                Gun modifiedGun;
                if (player.m_21206_().m_41720_() instanceof ShieldItem && (modifiedGun = gunItem.getModifiedGun(heldItem)).getGeneral().getGripType() == GripType.ONE_HANDED) {
                    return;
                }
                event.setCanceled(true);
                event.setSwingHand(false);
                return;
            }
            if (AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            this.shooting = false;
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && !PlayerReviveHelper.isBleeding((Player)player)) {
                boolean shooting;
                Gun gun = gunItem.getModifiedGun(heldItem);
                boolean bl = shooting = KeyBinds.getShootMapping().m_90857_() || (Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) > 0 && gun.getGeneral().getFireMode() == FireMode.BURST;
                if (JustEnoughGuns.controllableLoaded) {
                    shooting |= ControllerHandler.isShooting();
                }
                if (!shooting) {
                    if (!this.shooting) return;
                    this.shooting = false;
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
                    return;
                }
                if (this.shooting) return;
                this.shooting = true;
                if (gun.getGeneral().getFireMode() == FireMode.BURST) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageBurst());
                }
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
                return;
            }
        }
        if (!this.shooting) return;
        this.shooting = false;
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            if (PlayerReviveHelper.isBleeding((Player)player)) {
                return;
            }
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem) {
                Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                if (!KeyBinds.getShootMapping().m_90857_() && gun.getGeneral().getFireTimer() != 0) {
                    this.fireTimer = gun.getGeneral().getFireTimer();
                }
                if ((KeyBinds.getShootMapping().m_90857_() || (Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) > 0 && gun.getGeneral().getFireMode() == FireMode.BURST) && gun.getGeneral().getFireMode() != FireMode.SEMI_AUTO && gun.getGeneral().getFireMode() != FireMode.PULSE) {
                    boolean doAutoFire;
                    this.fire((Player)player, heldItem);
                    boolean bl = doAutoFire = gun.getGeneral().getFireMode() == FireMode.AUTOMATIC || gun.getGeneral().getFireMode() == FireMode.BURST;
                    if (!doAutoFire) {
                        KeyBinds.getShootMapping().m_7249_(false);
                    }
                }
                if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
                    KeyBinds.getShootMapping().m_7249_(false);
                    ModSyncedDataKeys.BURST_COUNT.setValue((Entity)player, (Object)0);
                }
                if (KeyBinds.getShootMapping().m_90857_()) {
                    if (gun.getGeneral().getFireTimer() != 0) {
                        ItemCooldowns tracker = player.m_36335_();
                        if (this.fireTimer > 0 && !tracker.m_41519_(heldItem.m_41720_())) {
                            if (this.fireTimer == gun.getGeneral().getFireTimer() - 2) {
                                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessagePreFireSound((Player)player));
                            }
                            if (player.m_5842_()) {
                                --this.fireTimer;
                            }
                            --this.fireTimer;
                        } else {
                            this.fire((Player)player, heldItem);
                            if (gun.getGeneral().getFireMode() == FireMode.SEMI_AUTO || gun.getGeneral().getFireMode() == FireMode.PULSE) {
                                mc.f_91066_.f_92096_.m_7249_(false);
                                this.fireTimer = gun.getGeneral().getFireTimer();
                            }
                        }
                    } else {
                        this.fire((Player)player, heldItem);
                        if (gun.getGeneral().getFireMode() == FireMode.SEMI_AUTO) {
                            mc.f_91066_.f_92096_.m_7249_(false);
                        }
                    }
                }
            }
        }
    }

    private boolean isEmpty(Player player, ItemStack heldItem) {
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return false;
        }
        return !Gun.hasAmmo(heldItem) && !player.m_7500_();
    }

    public void fire(Player player, ItemStack heldItem) {
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (player.m_21211_().m_41720_() instanceof ShieldItem) {
            return;
        }
        if (this.isEmpty(player, heldItem)) {
            if ((Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) > 0) {
                ModSyncedDataKeys.BURST_COUNT.setValue((Entity)player, (Object)0);
            }
            return;
        }
        ItemCooldowns tracker = player.m_36335_();
        int maxDamage = heldItem.m_41776_();
        int currentDamage = heldItem.m_41773_();
        if (!tracker.m_41519_(heldItem.m_41720_())) {
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            ItemStack stack = player.m_21205_();
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            int rate = GunEnchantmentHelper.getRate(heldItem, modifiedGun);
            rate = GunModifierHelper.getModifiedRate(heldItem, rate);
            if (stack.m_41763_() && currentDamage < maxDamage - 1) {
                tracker.m_41524_(heldItem.m_41720_(), rate);
                int gunBurstCount = modifiedGun.getGeneral().getBurstAmount();
                if (modifiedGun.getGeneral().getFireMode() == FireMode.BURST) {
                    if ((Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) == 1) {
                        tracker.m_41524_(heldItem.m_41720_(), modifiedGun.getGeneral().getBurstDelay());
                    }
                    if ((Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) <= 0) {
                        ModSyncedDataKeys.BURST_COUNT.setValue((Entity)player, (Object)(gunBurstCount - 1));
                    } else if ((Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) > 0) {
                        ModSyncedDataKeys.BURST_COUNT.setValue((Entity)player, (Object)((Integer)ModSyncedDataKeys.BURST_COUNT.getValue((Entity)player) - 1));
                    }
                }
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(player));
                MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
            } else if (!stack.m_41763_()) {
                tracker.m_41524_(heldItem.m_41720_(), rate);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(player));
                MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
            }
        }
    }
}

