/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.client.handler.ControllerHandler;
import ttv.migami.jeg.client.util.PropertyHelper;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.compat.PlayerReviveHelper;
import ttv.migami.jeg.debug.Debug;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageAim;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class AimingHandler {
    private static AimingHandler instance;
    private static final double MAX_AIM_PROGRESS = 5.0;
    private final AimTracker localTracker = new AimTracker();
    private final Map<Player, AimTracker> aimingMap = new WeakHashMap<Player, AimTracker>();
    private double normalisedAdsProgress;
    private boolean aiming = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    private AimingHandler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            tracker.handleAiming(player, player.m_21120_(InteractionHand.MAIN_HAND));
            if (!tracker.isAiming()) {
                this.aimingMap.remove(player);
            }
        }
    }

    @Nullable
    private AimTracker getAimTracker(Player player) {
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() && !this.aimingMap.containsKey(player)) {
            this.aimingMap.put(player, new AimTracker());
        }
        return this.aimingMap.get(player);
    }

    public float getAimProgress(Player player, float partialTicks) {
        if (player.m_7578_()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.isAiming()) {
            if (!this.aiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(true));
                this.aiming = true;
            }
        } else if (this.aiming) {
            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
            this.aiming = false;
        }
        this.localTracker.handleAiming((Player)player, player.m_21120_(InteractionHand.MAIN_HAND));
    }

    @SubscribeEvent
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_21205_().m_41619_() || mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (AimingHandler.get().getNormalisedAdsProgress() == 0.0) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return;
        }
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getModules().getZoom() == null) {
            return;
        }
        double time = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getFovCurve().apply(this.normalisedAdsProgress);
        float modifier = Gun.getFovModifier(heldItem, modifiedGun);
        modifier = (1.0f - modifier) * (float)time;
        event.setFOV(event.getFOV() - event.getFOV() * (double)modifier);
    }

    @SubscribeEvent
    public void onClientTick(ClientPlayerNetworkEvent.LoggingOut event) {
        this.aimingMap.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTick());
    }

    public boolean isZooming() {
        return this.aiming;
    }

    public boolean isAiming() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91074_.m_5833_()) {
            return false;
        }
        if (Debug.isForceAim()) {
            return true;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (PlayerReviveHelper.isBleeding((Player)mc.f_91074_)) {
            return false;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (!gun.canAimDownSight()) {
            return false;
        }
        Item item = mc.f_91074_.m_21205_().m_41720_();
        if (item instanceof AnimatedGunItem) {
            AnimatedGunItem gunItem = (AnimatedGunItem)item;
            long id = GeoItem.getId((ItemStack)heldItem);
            AnimationController animationController = (AnimationController)gunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            if (animationController != null && animationController.getCurrentAnimation() != null && (animationController.getCurrentAnimation().animation().name().matches("draw") || animationController.getCurrentAnimation().animation().name().matches("jam"))) {
                return false;
            }
        }
        if (mc.f_91074_.m_21206_().m_41720_() instanceof ShieldItem && gun.getGeneral().getGripType() == GripType.ONE_HANDED) {
            return false;
        }
        if (!this.localTracker.isAiming() && this.isLookingAtInteractableBlock()) {
            return false;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return false;
        }
        boolean zooming = KeyBinds.getAimMapping().m_90857_();
        if (JustEnoughGuns.controllableLoaded) {
            zooming |= ControllerHandler.isAiming();
        }
        return zooming;
    }

    public boolean isLookingAtInteractableBlock() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ != null && mc.f_91073_ != null) {
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockState state = mc.f_91073_.m_8055_(result.m_82425_());
                Block block = state.m_60734_();
                return block instanceof EntityBlock && !state.m_60713_((Block)ModBlocks.DYNAMIC_LIGHT.get()) || block == Blocks.f_50091_ || block == ModBlocks.SCRAP_WORKBENCH.get() || block == ModBlocks.GUNMETAL_WORKBENCH.get() || block == ModBlocks.GUNNITE_WORKBENCH.get() || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(Tags.Blocks.CHESTS) || state.m_204336_(Tags.Blocks.FENCE_GATES);
            }
            hitResult = mc.f_91077_;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult result = (EntityHitResult)hitResult;
                return result.m_82443_() instanceof ItemFrame;
            }
        }
        return false;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public class AimTracker {
        private double currentAim;
        private double previousAim;

        private void handleAiming(Player player, ItemStack heldItem) {
            this.previousAim = this.currentAim;
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() || player.m_7578_() && AimingHandler.this.isAiming()) {
                if (this.currentAim < 5.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    this.currentAim += speed;
                    if (this.currentAim > 5.0) {
                        this.currentAim = 5.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                this.currentAim -= speed;
                if (this.currentAim < 0.0) {
                    this.currentAim = 0.0;
                }
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        public double getNormalProgress(float partialTicks) {
            return Mth.m_14008_((double)((this.previousAim + (this.currentAim - this.previousAim) * (double)partialTicks) / 5.0), (double)0.0, (double)1.0);
        }
    }
}

