/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import ttv.migami.jeg.blockentity.DynamicLightBlockEntity;

public class DynamicLightBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DynamicLightBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278788_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_56744_).m_60913_(1.0f, 10.0f).m_60953_(s -> 8).m_60910_().m_60955_().m_278166_(PushReaction.IGNORE).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 1);
        DynamicLightBlock.removeDelay((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void removeDelay(LevelAccessor world, double x, double y, double z) {
        BlockPos blockPos;
        BlockEntity blockEntity;
        if (!world.m_5776_() && (blockEntity = world.m_7702_(blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z))) != null && blockEntity.getPersistentData().m_128459_("Delay") != 5.0) {
            blockEntity.getPersistentData().m_128347_("Delay", 5.0);
            if (world instanceof Level) {
                Level level = (Level)world;
                level.m_7260_(blockPos, world.m_8055_(blockPos), world.m_8055_(blockPos), 3);
            }
        }
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockstate, world, pos, random);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        DynamicLightBlock.execute((LevelAccessor)world, x, y, z);
        world.m_186460_(pos, (Block)this, 1);
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (!world.m_5776_()) {
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            double delay = DynamicLightBlock.getDelay(world, blockPos, "Delay");
            if (delay > 0.0) {
                BlockEntity blockEntity = world.m_7702_(blockPos);
                if (blockEntity != null) {
                    blockEntity.getPersistentData().m_128347_("Delay", delay - 1.0);
                }
            } else {
                BlockState newState;
                BlockState currentState = world.m_8055_(blockPos);
                BlockState blockState = newState = currentState.m_60819_().m_76170_() ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
                if (currentState != newState) {
                    world.m_7731_(blockPos, newState, 3);
                }
            }
        }
    }

    public static double getDelay(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null ? blockEntity.getPersistentData().m_128459_(tag) : -1.0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DynamicLightBlockEntity(pos, state);
    }
}

