/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticleData;
import rbasamoyai.createbigcannons.munitions.fragment_burst.CBCProjectileBurst;
import rbasamoyai.createbigcannons.network.ClientboundFluidBlobStackSyncPacket;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurstClipContext;

public class FluidBlobBurst
extends CBCProjectileBurst {
    private static final EntityDataAccessor<Byte> BLOB_SIZE = SynchedEntityData.m_135353_(FluidBlobBurst.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private EndFluidStack fluidStack = EndFluidStack.EMPTY;
    private final Set<Entity> clippedThisTick = new HashSet<Entity>();

    public FluidBlobBurst(EntityType<? extends FluidBlobBurst> entityType, Level level) {
        super(entityType, level);
    }

    public static float getBlockAffectChance() {
        return CBCConfigs.SERVER.munitions.fluidBlobBlockAffectChance.getF();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOB_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Size", this.getBlobSize());
        tag.m_128365_("Fluid", (Tag)this.getFluidStack().writeTag(new CompoundTag()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setBlobSize(tag.m_128445_("Size"));
        this.setFluidStack(EndFluidStack.readTag(tag.m_128469_("Fluid")));
    }

    protected void setBlobSize(byte size) {
        this.f_19804_.m_135381_(BLOB_SIZE, (Object)(size < 0 ? (byte)0 : size));
    }

    public byte getBlobSize() {
        return (Byte)this.f_19804_.m_135370_(BLOB_SIZE);
    }

    public void setFluidStack(EndFluidStack fstack) {
        this.fluidStack = fstack;
    }

    public EndFluidStack getFluidStack() {
        return this.fluidStack;
    }

    public double getSubProjectileWidth() {
        return 0.8;
    }

    public double getSubProjectileHeight() {
        return 0.8;
    }

    @Override
    public void m_8119_() {
        this.clippedThisTick.clear();
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46467_() % 3L == 0L) {
            NetworkPlatform.sendToClientTracking(new ClientboundFluidBlobStackSyncPacket(this), (Entity)this);
        }
        if (this.m_9236_().f_46443_ && !this.getFluidStack().isEmpty()) {
            for (ProjectileBurst.SubProjectile subProjectile : this.subProjectiles) {
                double[] disp = subProjectile.displacement();
                double[] vel = subProjectile.velocity();
                this.m_9236_().m_7106_((ParticleOptions)new FluidBlobParticleData((float)this.getBlobSize() * 0.25f + 1.0f, this.getFluidStack().copy()), this.m_20185_() + disp[0], this.m_20186_() + disp[1], this.m_20189_() + disp[2], vel[0], vel[1], vel[2]);
            }
        }
    }

    protected HitResult clipAndDamage(ProjectileBurst.SubProjectile info) {
        Vec3 vel = new Vec3(info.velocity()[0], info.velocity()[1], info.velocity()[2]);
        Vec3 start = new Vec3(info.displacement()[0] + this.m_20185_(), info.displacement()[1] + this.m_20186_(), info.displacement()[2] + this.m_20189_());
        Vec3 end = start.m_82549_(vel);
        double halfHeight = this.getSubProjectileHeight() / 2.0;
        double halfWidth = this.getSubProjectileWidth() / 2.0;
        BlockHitResult hitResult = this.m_9236_().m_45547_((ClipContext)new ProjectileBurstClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this, start.f_82480_ - halfHeight));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            end = hitResult.m_82450_();
        }
        AABB aabb = new AABB(start.f_82479_ - halfWidth, start.f_82480_ - halfHeight, start.f_82481_ - halfWidth, start.f_82479_ + halfWidth, start.f_82480_ + halfHeight, start.f_82481_ + halfWidth).m_82400_((double)this.getBlobSize());
        this.clipEntities(start, end, aabb.m_82369_(vel).m_82400_(1.0), info);
        return hitResult;
    }

    private void clipEntities(Vec3 startVec, Vec3 endVec, AABB boundingBox, ProjectileBurst.SubProjectile subProjectile) {
        float inflate = (float)this.getBlobSize() + 0.3f;
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, boundingBox, this::m_5603_)) {
            AABB entityBB = entity.m_20191_().m_82400_((double)inflate);
            Optional optional = entityBB.m_82371_(startVec, endVec);
            if (!optional.isPresent()) continue;
            this.onSubProjectileHitEntity(new EntityHitResult(entity), subProjectile);
        }
    }

    @Override
    public boolean m_5603_(Entity target) {
        return !this.clippedThisTick.contains(target) && super.m_5603_(target);
    }

    protected void onSubProjectileHit(HitResult result, ProjectileBurst.SubProjectile subProjectile) {
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnAllHit(this, subProjectile, result);
        }
        super.onSubProjectileHit(result, subProjectile);
    }

    protected void onSubProjectileHitBlock(BlockHitResult result, ProjectileBurst.SubProjectile subProjectile) {
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnHitBlock(this, subProjectile, result);
        }
        super.onSubProjectileHitBlock(result, subProjectile);
    }

    protected void onSubProjectileHitEntity(EntityHitResult result, ProjectileBurst.SubProjectile subProjectile) {
        this.clippedThisTick.add(result.m_82443_());
        if (!this.m_9236_().f_46443_) {
            FluidBlobEffectRegistry.effectOnHitEntity(this, subProjectile, result);
        }
        super.onSubProjectileHitEntity(result, subProjectile);
    }

    public AABB getAreaOfEffect(BlockPos pos) {
        return new AABB(pos).m_82400_((double)this.getBlobSize());
    }
}

