/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.silverdungeon;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.loot.AetherLoot;
import com.aetherteam.aether.world.processor.DoubleDropsProcessor;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonPiece;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SilverDungeonRoom
extends SilverDungeonPiece {
    public SilverDungeonRoom(StructureTemplateManager manager, String name, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)AetherStructurePieceTypes.SILVER_DUNGEON_ROOM.get(), manager, name, SilverDungeonRoom.makeSettings(manager, rotation, new ResourceLocation("aether", "silver_dungeon/" + name)), pos);
        this.m_73519_(rotation.m_55954_(Direction.SOUTH));
    }

    public SilverDungeonRoom(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)AetherStructurePieceTypes.SILVER_DUNGEON_ROOM.get(), tag, context.f_226956_(), (ResourceLocation id) -> SilverDungeonRoom.makeSettings(context.f_226956_(), id));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager manager, Rotation rotation, ResourceLocation id) {
        return SilverDungeonRoom.makeSettings(manager, id).m_74379_(rotation);
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager manager, ResourceLocation id) {
        StructureTemplate template = manager.m_230359_(id);
        BlockPos pivot = new BlockPos(template.m_163801_().m_123341_() / 2 - 4, 0, template.m_163801_().m_123343_() / 2 - 4);
        return new StructurePlaceSettings().m_74385_(pivot).m_74383_((StructureProcessor)SilverDungeonPiece.LOCKED_ANGELIC_STONE).m_74383_((StructureProcessor)DoubleDropsProcessor.INSTANCE);
    }

    @Override
    protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        if (name.equals("Chest")) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            BlockPos.MutableBlockPos chestPos = pos.m_122032_();
            chestPos.m_122178_(this.f_73383_.m_162395_() + random.m_188503_(this.f_73383_.m_71056_()), pos.m_123342_(), this.f_73383_.m_162398_() + random.m_188503_(this.f_73383_.m_71058_()));
            this.placeChestOrMimic(level, box, random, (BlockPos)(box.m_71051_((Vec3i)chestPos) ? chestPos : pos));
        }
    }

    private void placeChestOrMimic(ServerLevelAccessor level, BoundingBox generatingChunk, RandomSource random, BlockPos pos) {
        BlockState state = (random.m_188503_(5) > 1 ? Blocks.f_50087_ : (Block)AetherBlocks.CHEST_MIMIC.get()).m_49966_();
        Direction facing = Direction.m_122407_((int)random.m_188503_(4));
        state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing);
        this.m_226762_(level, generatingChunk, random, pos, AetherLoot.SILVER_DUNGEON, state);
    }
}

