/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk;

import com.aetherteam.nitrogen.api.users.User;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;

public final class PerkUtil {
    public static Predicate<User> hasLifetimeValkyrieMoaSkins() {
        return user -> PerkUtil.hasAllSkins().test((User)user) || user.getCurrentTierLevel() >= User.Tier.VALKYRIE.getLevel() || user.getCurrentTier() == null && user.getHighestPastTierLevel() >= User.Tier.VALKYRIE.getLevel();
    }

    public static Predicate<User> hasLifetimeAscentanMoaSkins() {
        return user -> PerkUtil.hasAllSkins().test((User)user) || PerkUtil.hasBaseSkins().test((User)user) || user.getCurrentTierLevel() >= User.Tier.ASCENTAN.getLevel() || user.getCurrentTier() == null && user.getHighestPastTierLevel() >= User.Tier.ASCENTAN.getLevel();
    }

    public static Predicate<User> hasValkyrieMoaSkins() {
        return user -> PerkUtil.hasAllSkins().test((User)user) || user.getCurrentTierLevel() >= User.Tier.VALKYRIE.getLevel();
    }

    public static Predicate<User> hasAscentanMoaSkins() {
        return user -> PerkUtil.hasAllSkins().test((User)user) || PerkUtil.hasBaseSkins().test((User)user) || user.getCurrentTierLevel() >= User.Tier.ASCENTAN.getLevel();
    }

    public static Predicate<User> hasHumanMoaSkins() {
        return user -> PerkUtil.hasAllSkins().test((User)user) || PerkUtil.hasBaseSkins().test((User)user) || user.getCurrentTierLevel() >= User.Tier.HUMAN.getLevel();
    }

    public static Predicate<User> hasBaseSkins() {
        return user -> PerkUtil.isContributor().test((User)user) || user.getHighestGroup() == User.Group.TRANSLATOR || user.getHighestGroup() == User.Group.CELEBRITY;
    }

    public static Predicate<User> hasAllSkins() {
        return user -> PerkUtil.isDeveloperOrStaff().test((User)user);
    }

    public static Predicate<User> hasDeveloperGlow() {
        return user -> PerkUtil.isDeveloper().test((User)user);
    }

    public static Predicate<User> hasHalo() {
        return user -> PerkUtil.isDeveloperOrStaff().test((User)user) || PerkUtil.isContributor().test((User)user);
    }

    public static Predicate<User> isDeveloperOrStaff() {
        return user -> PerkUtil.isDeveloper().test((User)user) || user.getHighestGroup() == User.Group.STAFF;
    }

    public static Predicate<User> isDeveloper() {
        return user -> user.getHighestGroup() == User.Group.AETHER_TEAM || user.getHighestGroup() == User.Group.MODDING_LEGACY;
    }

    public static Predicate<User> isContributor() {
        return user -> user.getHighestGroup() == User.Group.CONTRIBUTOR || user.getHighestGroup() == User.Group.LEGACY_CONTRIBUTOR;
    }

    @Nullable
    public static Triple<Float, Float, Float> getPerkColor(@Nullable String hex) {
        if (hex != null && !hex.isEmpty()) {
            try {
                int decimal = Integer.parseInt(hex, 16);
                int r = (decimal & 0xFF0000) >> 16;
                int g = (decimal & 0xFF00) >> 8;
                int b = decimal & 0xFF;
                return Triple.of((Object)Float.valueOf((float)r / 255.0f), (Object)Float.valueOf((float)g / 255.0f), (Object)Float.valueOf((float)b / 255.0f));
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }
        return null;
    }
}

