/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.component.menu.AetherMenuButton;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.AetherModUpdateIndicator;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.internal.BrandingControl;

public class AetherTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation AETHER_LOGO = new ResourceLocation("aether", "textures/gui/title/aether.png");
    public static final Music MENU = new Music((Holder)AetherSoundEvents.MUSIC_MENU.getHolder().orElseThrow(), 20, 600, true);
    private final PanoramaRenderer panorama = new PanoramaRenderer(new CubeMap(new ResourceLocation("aether", "textures/gui/title/panorama/panorama")));
    private AetherModUpdateIndicator modUpdateNotification;
    private boolean alignedLeft;
    private int rows;

    public AetherTitleScreen() {
        ((TitleScreenAccessor)((Object)this)).aether$setFading(true);
    }

    public AetherTitleScreen(boolean alignedLeft) {
        this();
        this.alignedLeft = alignedLeft;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupButtons();
        this.modUpdateNotification = new AetherModUpdateIndicator(this);
        this.modUpdateNotification.m_7856_();
    }

    public void setupButtons() {
        int buttonRows = 0;
        int lastY = 0;
        if (((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue()) {
            Component component = ((TitleScreenAccessor)((Object)this)).callGetMultiplayerDisabledReason();
            boolean flag = component == null;
            Tooltip tooltip = component != null ? Tooltip.m_257550_((Component)component) : null;
            Button serverButton = this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"gui.aether.menu.server"), button -> {
                ServerData serverData = new ServerData("OATS", "oats.aether-mod.net", false);
                ConnectScreen.m_278792_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData, (boolean)false);
            }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 48 + 72, 200, 20).m_257505_(tooltip).m_253136_());
            serverButton.f_93623_ = flag;
            Predicate<AbstractWidget> predicate = abstractWidget -> abstractWidget.m_6035_().equals(Component.m_237115_((String)"menu.multiplayer")) || abstractWidget.m_6035_().equals(Component.m_237115_((String)"menu.online"));
            this.m_6702_().removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
            this.f_169369_.removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
        }
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget2 = (AbstractWidget)renderable;
            Component buttonText = abstractWidget2.m_6035_();
            if (TitleScreenBehavior.isImageButton(buttonText)) {
                abstractWidget2.f_93624_ = false;
            }
            if (!(abstractWidget2 instanceof AetherMenuButton)) continue;
            AetherMenuButton aetherMenuButton = (AetherMenuButton)abstractWidget2;
            if (this.isAlignedLeft()) {
                ++buttonRows;
            } else if (lastY < aetherMenuButton.originalY) {
                lastY = aetherMenuButton.originalY;
                ++buttonRows;
            }
            if (buttonText.equals(Component.m_237115_((String)"gui.aether.menu.server"))) {
                aetherMenuButton.serverButton = true;
                aetherMenuButton.buttonCountOffset = 2;
            } else {
                aetherMenuButton.buttonCountOffset = buttonRows;
            }
            if (!((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue() || !buttonText.equals(Component.m_237115_((String)"menu.singleplayer"))) continue;
            ++buttonRows;
        }
        this.rows = this.alignedLeft ? buttonRows : buttonRows - 1;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)((Object)this);
        if (this.f_96541_ != null && titleScreenAccessor.aether$getSplash() == null) {
            titleScreenAccessor.aether$setSplash(this.f_96541_.m_91310_().m_280369_());
        }
        float fadeAmount = TitleScreenBehavior.super.handleFading(guiGraphics, this, titleScreenAccessor, this.panorama, PANORAMA_OVERLAY, partialTicks);
        float scale = AetherTitleScreen.getScale(this, this.getMinecraft());
        this.setupLogo(guiGraphics, fadeAmount, scale);
        int roundedFadeAmount = Mth.m_14167_((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            SplashRendererAccessor splashRendererAccessor;
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (GuiGraphics)guiGraphics, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null && (splashRendererAccessor = (SplashRendererAccessor)titleScreenAccessor.aether$getSplash()).cumulus$getSplash() != null && !splashRendererAccessor.cumulus$getSplash().isEmpty()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                float splashX = this.alignedLeft ? 400.0f / scale : (float)this.f_96543_ / 2.0f + 175.0f / scale;
                float splashY = this.alignedLeft ? 100.0f / scale : (float)((int)(20.0f + 76.0f / scale));
                poseStack.m_85836_();
                poseStack.m_252880_(splashX, splashY, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-20.0f));
                float textSize = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                textSize = textSize * (200.0f / scale) / ((float)this.f_96547_.m_92895_(splashRendererAccessor.cumulus$getSplash()) + 64.0f / scale);
                poseStack.m_85841_(textSize, textSize, textSize);
                guiGraphics.m_280137_(this.f_96547_, splashRendererAccessor.cumulus$getSplash(), 0, (int)(-16.0f / scale), 0xFFFF00 | roundedFadeAmount);
                poseStack.m_85849_();
            }
            if (this.alignedLeft) {
                TitleScreenBehavior.super.renderRightBranding(guiGraphics, this, this.f_96547_, roundedFadeAmount);
            } else {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
                    int n = brandingLine;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, branding, 2, this.f_96544_ - (10 + n * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
                BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
                    int n = this.f_96543_ - this.f_96547_.m_92895_(branding);
                    int n2 = brandingLine + 1;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, branding, n, this.f_96544_ - (10 + n2 * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
            }
        }
        int xOffset = TitleScreenBehavior.super.handleButtonVisibility(this, fadeAmount);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (renderable instanceof AetherMenuButton) {
                AetherMenuButton aetherButton = (AetherMenuButton)renderable;
                if (aetherButton.m_5953_(mouseX, mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 4;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        TitleScreenBehavior.super.handleImageButtons(this, xOffset);
        if (fadeAmount >= 1.0f) {
            this.modUpdateNotification.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    private void setupLogo(GuiGraphics guiGraphics, float transparency, float scale) {
        int width = (int)(350.0f / scale);
        int height = (int)(76.0f / scale);
        int logoX = this.alignedLeft ? (int)(10.0f + 18.0f / scale) : (int)((float)(this.f_96543_ / 2) - 175.0f / scale);
        int logoY = this.alignedLeft ? (int)(15.0f + 10.0f / scale) : (int)(25.0f + 10.0f / scale);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.m_280163_(AETHER_LOGO, logoX, logoY, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static float getScale(AetherTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        return AetherTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(AetherTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = AetherMenuButton.totalHeightRange(screen.rows, scale)) > screen.f_96544_ && scale != 1.0f) {
            return AetherTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    protected <T extends GuiEventListener & Renderable> T m_142416_(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((button = (Button)renderable).m_6035_())) {
            AetherMenuButton aetherButton = new AetherMenuButton(this, button);
            return (T)super.m_142416_((GuiEventListener)aetherButton);
        }
        return (T)super.m_142416_(renderable);
    }

    public boolean isAlignedLeft() {
        return this.alignedLeft;
    }
}

