/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.github.alexthe666.alexsmobs.entity.EntityStradpole;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityStradpole.class})
public abstract class AMIStradpole
extends Mob {
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> LAUNCHED;
    private int despawnTimer = 0;
    private static final EntityDataAccessor<Integer> HOPUPTICK;
    double y2;

    @Shadow
    public abstract boolean isDespawnSoon();

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(HOPUPTICK, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("HopUpTick", this.getHopUpTick());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setHopUpTick(compound.m_128451_("HopUpTick"));
    }

    public int getHopUpTick() {
        return (Integer)this.f_19804_.m_135370_(HOPUPTICK);
    }

    public void setHopUpTick(int hopUpTick) {
        this.f_19804_.m_135381_(HOPUPTICK, (Object)hopUpTick);
    }

    protected AMIStradpole(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (AMInteractionConfig.STRADPOLE_BOB_UP_ENABLED) {
            this.setHopUpTick(this.getHopUpTick() + 1);
            if (this.getHopUpTick() >= 200 + this.f_19796_.m_188503_(600) && this.m_20077_()) {
                this.y2 = 0.05 + this.y2;
                this.m_20334_(0.0, this.y2, 0.0);
            }
            if (!this.m_20077_()) {
                this.setHopUpTick(0);
                this.y2 = 0.0;
            }
        }
        if (AMInteractionConfig.GOOFY_STRADDLER_SHOTGUN_ENABLED && AMInteractionConfig.GOOFY_MODE_ENABLED && this.isDespawnSoon()) {
            int x = this.m_146903_();
            int y = this.m_146904_();
            int z = this.m_146907_();
            ++this.despawnTimer;
            if (this.despawnTimer > 80) {
                this.despawnTimer = 0;
                this.m_21373_();
                this.m_9236_().m_254849_((Entity)this, (double)(x + 1), (double)(y + 2), (double)(z + 1), 3.0f, Level.ExplosionInteraction.NONE);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268671_);
    }

    @Inject(method={"onEntityHit"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void entityhit(EntityHitResult raytraceresult, CallbackInfo ci) {
        Entity var4;
        ci.cancel();
        EntityStradpole stradpole = (EntityStradpole)this;
        Entity entity = stradpole.getParent();
        if (entity instanceof LivingEntity && !this.m_9236_().f_46443_ && (var4 = raytraceresult.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)var4;
            if (AMInteractionConfig.STRADPOLE_FLAME_ENABLED && this.f_19796_.m_188500_() < 0.2) {
                target.m_20254_(2);
            }
            if (!target.m_21254_()) {
                target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)entity), 3.0f);
                target.m_147240_((double)0.7f, entity.m_20185_() - this.m_20185_(), entity.m_20189_() - this.m_20189_());
            } else if (this.m_5448_() instanceof Player) {
                this.damageShieldFor((Player)this.m_5448_(), 3.0f);
            }
            this.f_19804_.m_135381_(LAUNCHED, (Object)false);
        }
    }

    protected void damageShieldFor(Player holder, float damage) {
        if (holder.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            if (!this.m_9236_().f_46443_) {
                holder.m_36246_(Stats.f_12982_.m_12902_((Object)holder.m_21211_().m_41720_()));
            }
            if (damage >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)damage);
                InteractionHand hand = holder.m_7655_();
                holder.m_21211_().m_41622_(i, (LivingEntity)holder, p_213833_1_ -> {
                    p_213833_1_.m_21190_(hand);
                    ForgeEventFactory.onPlayerDestroyItem((Player)holder, (ItemStack)holder.m_21211_(), (InteractionHand)hand);
                });
                if (holder.m_21211_().m_41619_()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        holder.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        holder.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    holder.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }

    static {
        HOPUPTICK = SynchedEntityData.m_135353_(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

