/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBoneSerpent;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityStraddler;
import com.github.alexthe666.alexsmobs.entity.EntityStradpole;
import com.github.alexthe666.alexsmobs.entity.EntityWarpedMosco;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityStraddler.class})
public class AMIStraddler
extends Mob {
    private static final EntityDataAccessor<Integer> SHOOTCOOLDOWN = SynchedEntityData.m_135353_(EntityStraddler.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOTSHOTS = SynchedEntityData.m_135353_(EntityStraddler.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(SHOOTCOOLDOWN, (Object)0);
        this.f_19804_.m_135372_(SHOOTSHOTS, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("ShootCooldown", this.getShootCooldown());
        compound.m_128405_("ShootShots", this.getShootShots());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setShootCooldown(compound.m_128451_("ShootCooldown"));
        this.setShootShots(compound.m_128451_("ShootShots"));
    }

    public int getShootCooldown() {
        return (Integer)this.f_19804_.m_135370_(SHOOTCOOLDOWN);
    }

    public void setShootCooldown(int shootcooldown) {
        this.f_19804_.m_135381_(SHOOTCOOLDOWN, (Object)shootcooldown);
    }

    public int getShootShots() {
        return (Integer)this.f_19804_.m_135370_(SHOOTSHOTS);
    }

    public void setShootShots(int shootshots) {
        this.f_19804_.m_135381_(SHOOTSHOTS, (Object)shootshots);
    }

    protected AMIStraddler(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"shouldShoot"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injected(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)this.doSomething4());
    }

    private boolean doSomething4() {
        if (AMInteractionConfig.STRADDLER_SHOTS_AMOUNT != 0) {
            return this.getShootShots() > 0;
        }
        return true;
    }

    public void m_8119_() {
        EntityStraddler straddler = (EntityStraddler)this;
        if (AMInteractionConfig.STRADDLER_SHOTS_AMOUNT != 0) {
            if (this.getShootShots() <= 0) {
                this.setShootCooldown(this.getShootCooldown() - 1);
            }
            if (this.getShootCooldown() <= 0 && this.getShootShots() <= 0) {
                this.setShootShots(AMInteractionConfig.STRADDLER_SHOTS_AMOUNT);
                this.setShootCooldown(100);
            }
        }
        super.m_8119_();
        this.floatStrider();
        this.m_20101_();
        if (straddler.getAnimation() == EntityStraddler.ANIMATION_LAUNCH && this.m_6084_() && straddler.getAnimationTick() == 2) {
            this.m_5496_(SoundEvents.f_11842_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        if (AMInteractionConfig.GOOFY_MODE_ENABLED && AMInteractionConfig.GOOFY_STRADDLER_SHOTGUN_ENABLED) {
            if (AMInteractionConfig.STRADDLER_SHOTS_AMOUNT != 0) {
                if (straddler.getAnimation() == EntityStraddler.ANIMATION_LAUNCH && this.m_6084_() && straddler.getAnimationTick() == 20 && this.m_5448_() != null && this.getShootShots() > 0) {
                    for (int i = 0; i < 15; ++i) {
                        int spread = this.f_19796_.m_188503_(10);
                        EntityStradpole pole = (EntityStradpole)((EntityType)AMEntityRegistry.STRADPOLE.get()).m_20615_(this.m_9236_());
                        pole.setParentId(this.m_20148_());
                        pole.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                        double d0 = this.m_5448_().m_20188_() - (double)1.1f;
                        double d1 = this.m_5448_().m_20185_() - this.m_20185_();
                        double d2 = d0 - pole.m_20186_();
                        double d3 = this.m_5448_().m_20189_() - this.m_20189_();
                        float f3 = Mth.m_14116_((float)((float)(d1 * d1 + d2 * d2 + d3 * d3))) * 0.2f;
                        this.m_146850_(GameEvent.f_157778_);
                        this.m_5496_(SoundEvents.f_11841_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                        pole.shoot(d1, d2 + (double)f3, d3, 2.0f, 0.0f + (float)spread);
                        pole.m_146922_(this.m_146908_() % 360.0f);
                        pole.m_146926_(Mth.m_14036_((float)this.m_146908_(), (float)-90.0f, (float)90.0f) % 360.0f);
                        if (!this.m_9236_().f_46443_) {
                            this.m_9236_().m_7967_((Entity)pole);
                        }
                        this.setShootShots(this.getShootShots() - 1);
                    }
                }
            } else if (straddler.getAnimation() == EntityStraddler.ANIMATION_LAUNCH && this.m_6084_() && straddler.getAnimationTick() == 20 && this.m_5448_() != null) {
                for (int i = 0; i < 15; ++i) {
                    int spread = this.f_19796_.m_188503_(100);
                    EntityStradpole pole = (EntityStradpole)((EntityType)AMEntityRegistry.STRADPOLE.get()).m_20615_(this.m_9236_());
                    pole.setParentId(this.m_20148_());
                    pole.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                    double d0 = this.m_5448_().m_20188_() - (double)1.1f;
                    double d1 = this.m_5448_().m_20185_() - this.m_20185_();
                    double d2 = d0 - pole.m_20186_();
                    double d3 = this.m_5448_().m_20189_() - this.m_20189_();
                    float f3 = Mth.m_14116_((float)((float)(d1 * d1 + d2 * d2 + d3 * d3))) * 0.2f;
                    this.m_146850_(GameEvent.f_157778_);
                    this.m_5496_(SoundEvents.f_11841_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    pole.shoot(d1, d2 + (double)f3, d3, 2.0f, 0.0f + (float)spread);
                    pole.m_146922_(this.m_146908_() % 360.0f);
                    pole.m_146926_(Mth.m_14036_((float)this.m_146908_(), (float)-90.0f, (float)90.0f) % 360.0f);
                    if (this.m_9236_().f_46443_) continue;
                    this.m_9236_().m_7967_((Entity)pole);
                }
            }
        } else if (AMInteractionConfig.STRADDLER_SHOTS_AMOUNT != 0) {
            if (straddler.getAnimation() == EntityStraddler.ANIMATION_LAUNCH && this.m_6084_() && straddler.getAnimationTick() == 20 && this.m_5448_() != null && this.getShootShots() > 0) {
                EntityStradpole pole = (EntityStradpole)((EntityType)AMEntityRegistry.STRADPOLE.get()).m_20615_(this.m_9236_());
                pole.setParentId(this.m_20148_());
                pole.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                double d0 = this.m_5448_().m_20188_() - (double)1.1f;
                double d1 = this.m_5448_().m_20185_() - this.m_20185_();
                double d2 = d0 - pole.m_20186_();
                double d3 = this.m_5448_().m_20189_() - this.m_20189_();
                float f3 = Mth.m_14116_((float)((float)(d1 * d1 + d2 * d2 + d3 * d3))) * 0.2f;
                this.m_146850_(GameEvent.f_157778_);
                this.m_5496_(SoundEvents.f_11841_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                pole.shoot(d1, d2 + (double)f3, d3, 2.0f, 0.0f);
                pole.m_146922_(this.m_146908_() % 360.0f);
                pole.m_146926_(Mth.m_14036_((float)this.m_146908_(), (float)-90.0f, (float)90.0f) % 360.0f);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7967_((Entity)pole);
                }
                this.setShootShots(this.getShootShots() - 1);
            }
        } else if (straddler.getAnimation() == EntityStraddler.ANIMATION_LAUNCH && this.m_6084_() && straddler.getAnimationTick() == 20 && this.m_5448_() != null) {
            EntityStradpole pole = (EntityStradpole)((EntityType)AMEntityRegistry.STRADPOLE.get()).m_20615_(this.m_9236_());
            pole.setParentId(this.m_20148_());
            pole.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            double d0 = this.m_5448_().m_20188_() - (double)1.1f;
            double d1 = this.m_5448_().m_20185_() - this.m_20185_();
            double d2 = d0 - pole.m_20186_();
            double d3 = this.m_5448_().m_20189_() - this.m_20189_();
            float f3 = Mth.m_14116_((float)((float)(d1 * d1 + d2 * d2 + d3 * d3))) * 0.2f;
            this.m_146850_(GameEvent.f_157778_);
            this.m_5496_(SoundEvents.f_11841_, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            pole.shoot(d1, d2 + (double)f3, d3, 2.0f, 0.0f);
            pole.m_146922_(this.m_146908_() % 360.0f);
            pole.m_146926_(Mth.m_14036_((float)this.m_146908_(), (float)-90.0f, (float)90.0f) % 360.0f);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7967_((Entity)pole);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)straddler);
    }

    private void floatStrider() {
        if (this.m_20077_()) {
            CollisionContext lvt_1_1_ = CollisionContext.m_82750_((Entity)this);
            double d1 = this.getFluidTypeHeight((FluidType)ForgeMod.LAVA_TYPE.get());
            if (d1 <= 0.5 && d1 > 0.0) {
                if (this.m_20184_().f_82480_ < 0.0) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                }
                this.m_6853_(true);
            } else if (lvt_1_1_.m_6513_(LiquidBlock.f_54690_, this.m_20183_().m_7495_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20334_(0.0, Math.min(d1 - 0.5, 1.0) * (double)0.2f, 0.0);
            }
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        EntityStraddler straddler = (EntityStraddler)this;
        if (AMInteractionConfig.STRADDLER_VENGEANCE_ENABLED) {
            straddler.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)straddler, EntityBoneSerpent.class, true));
            straddler.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)straddler, EntityCrimsonMosquito.class, true));
            straddler.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)straddler, EntityWarpedMosco.class, true));
        }
    }
}

